local cockpit = folder.."../../../cockpit/C-101EB/"
dofile(cockpit.."../Common/devices_common.lua")
dofile(cockpit.."devices.lua")
dofile(cockpit.."../Common/command_defs.lua")
local base = external_profile("Config/Input/Aircrafts/common_joystick_binding.lua")
local rearCptSuffix = _('(Rear Cockpit)')

join(base.keyCommands,{

-------------------------------------------------------------Main panel----------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------

-- Flight director
{down = device_commands.Button_170, up = device_commands.Button_170, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('FD GO-AROUND mode'), category = {_('Main instrument panel'), _('Flight director')}},
{down = device_commands.Button_171, up = device_commands.Button_171, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('FD HEADING mode'), category = {_('Main instrument panel'), _('Flight director')}},
{down = device_commands.Button_172, up = device_commands.Button_172, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('FD ALTITUDE HOLD mode'), category = {_('Main instrument panel'), _('Flight director')}},
{down = device_commands.Button_173, up = device_commands.Button_173, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('FD PITCH HOLD mode'), category = {_('Main instrument panel'), _('Flight director')}},
{down = device_commands.Button_174, up = device_commands.Button_174, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('FD VOR/LOC mode'), category = {_('Main instrument panel'), _('Flight director')}},
{down = device_commands.Button_175, up = device_commands.Button_175, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('FD APPROACH ARM mode'), category = {_('Main instrument panel'), _('Flight director')}},
{down = device_commands.Button_176, up = device_commands.Button_176, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('FD GLIDESLOPE mode'), category = {_('Main instrument panel'), _('Flight director')}},
{down = device_commands.Button_177, up = device_commands.Button_177, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('FD LOC REVERSE mode'), category = {_('Main instrument panel'), _('Flight director')}},
{down = device_commands.Button_178, up = device_commands.Button_178, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('FD STANDBY mode'), category = {_('Main instrument panel'), _('Flight director')}},
{down = device_commands.Button_179, up = device_commands.Button_179, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('FD GLIDESLOPE EXTENDED mode'), category = {_('Main instrument panel'), _('Flight director')}},

--Altimeter
{pressed = device_commands.Button_19, cockpit_device_id = devices.SYSTEMS, value_pressed = -1.0, name = _('Altimeter pressure set Decrease'), category = _('Main instrument panel')},
{pressed = device_commands.Button_19, cockpit_device_id = devices.SYSTEMS, value_pressed = 1.0, name = _('Altimeter pressure set Increase'), category = _('Main instrument panel')},
--Fuel flow
{down = device_commands.Button_234, up = device_commands.Button_234, cockpit_device_id = devices.SYSTEMS,value_down = 0.0,value_up = 1.0, name = _('Fuel flow Reset'), category = _('Main instrument panel')},
{down = device_commands.Button_235, up = device_commands.Button_235, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Fuel flow test'), category = _('Main instrument panel')},

--Acceleration g units
{down = device_commands.Button_42, up = device_commands.Button_42, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Reset Max/Min Needles'), category = _('Main instrument panel')},

--Markers
{down = device_commands.Button_167, up = device_commands.Button_167, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Outer marker lamp test'), category = _('Main instrument panel')},
{down = device_commands.Button_168, up = device_commands.Button_168, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Middle marker lamp test'), category = _('Main instrument panel')},
{down = device_commands.Button_169, up = device_commands.Button_169, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Inner marker lamp test'), category = _('Main instrument panel')},

{pressed = device_commands.Button_907, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('Outer Marker Dimmer Increase'), category = _('Main instrument panel')},
{pressed = device_commands.Button_907, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('Outer Marker Dimmer Decrease'), category = _('Main instrument panel')},

{pressed = device_commands.Button_909, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('Middle Marker Dimmer Increase'), category = _('Main instrument panel')},
{pressed = device_commands.Button_909, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('Middle Marker Dimmer Decrease'), category = _('Main instrument panel')},

{pressed = device_commands.Button_911, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('Inner Marker Dimmer Increase'), category = _('Main instrument panel')},
{pressed = device_commands.Button_911, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('Inner Marker Dimmer Decrease'), category = _('Main instrument panel')},

--Korry Buttons- UHF, VHF, NAV, TACAN/VOR
{down = device_commands.Button_37, up = device_commands.Button_37, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('VOR/TCN Nav Selector'), category = _('Main instrument panel')},
{down = device_commands.Button_119, up = device_commands.Button_119, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('NAV Priority'), category = _('Main instrument panel')},
{down = device_commands.Button_162, up = device_commands.Button_162, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('UHF Priority'), category = _('Main instrument panel')},
{down = device_commands.Button_163, up = device_commands.Button_163, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('VHF Priority'), category = _('Main instrument panel')},

--HSI Brightness
{pressed = device_commands.Button_180, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('HSI digit brightness Decrease'), category = _('Main instrument panel')},
{pressed = device_commands.Button_180, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('HSI digit brightness Increase'), category = _('Main instrument panel')},

--Air Speed
{pressed = device_commands.Button_237, cockpit_device_id = devices.SYSTEMS, value_pressed = -0.005, name = _('Airspeed indicator bug Decrease'), category = _('Main instrument panel')},
{pressed = device_commands.Button_237, cockpit_device_id = devices.SYSTEMS, value_pressed = 0.005, name = _('Airspeed indicator bug Increase'), category = _('Main instrument panel')},

--ADI
{down = device_commands.Button_166, up = device_commands.Button_166, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Attitude test'), category = _('Main instrument panel')},

{pressed = device_commands.Button_181, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('ADI Pitch adjust Decrease'), category = _('Main instrument panel')},
{pressed = device_commands.Button_181, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('ADI Pitch adjust Increase'), category = _('Main instrument panel')},

--Clock
{down = device_commands.Button_149, up = device_commands.Button_149, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Chronograph'), category = _('Main instrument panel')},

{pressed = device_commands.Button_147, cockpit_device_id = devices.SYSTEMS, value_pressed = 0.0, name = _('Clock Setting Knob - PUSH'), category = _('Main instrument panel')},
{pressed = device_commands.Button_147, cockpit_device_id = devices.SYSTEMS, value_pressed = 1.0, name = _('Clock Setting Knob - PULL'), category = _('Main instrument panel')},

{pressed = device_commands.Button_148, cockpit_device_id = devices.SYSTEMS, value_pressed = -0.008, name = _('Clock Setting Knob - Counterclockwise'), category = _('Main instrument panel')},
{pressed = device_commands.Button_148, cockpit_device_id = devices.SYSTEMS, value_pressed = 0.008, name = _('Clock Setting Knob - Clockwise'), category = _('Main instrument panel')},

--Back up ADI
{down = device_commands.Button_14, up = device_commands.Button_14, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Back up ADI Cage'), category = _('Main instrument panel')},

{pressed = device_commands.Button_922, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('Pitch Reference Adjust Decrease'), category = _('Main instrument panel')},
{pressed = device_commands.Button_922, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('Pitch Reference Adjust Increase'), category = _('Main instrument panel')},

--UHF RADIO AN/ARC-164(V) DIGITAL DISPLAY
{pressed = device_commands.Button_64, cockpit_device_id  = devices.ARC164, value_pressed = -1, name = _('UHF Dimmer Decrease'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},
{pressed = device_commands.Button_64, cockpit_device_id  = devices.ARC164, value_pressed =  1, name = _('UHF Dimmer Increase'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},

{down = device_commands.Button_62, cockpit_device_id = devices.ARC164, value_down = 1, value_up = 0, name = _('UHF Digital display frequency mode'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},
{down = device_commands.Button_63, up = device_commands.Button_63, cockpit_device_id = devices.ARC164, value_down = 1, value_up = 0, name = _('UHF Digital display test'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},

--UHF RADIO AN/ARC-164(V)
{down = device_commands.Button_9, up = device_commands.Button_9, cockpit_device_id = devices.ARC164,value_down = 1,value_up = 0, name = _('UHF tone button'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},

{down = device_commands.Button_10, cockpit_device_id  = devices.ARC164, value_down = 0, name = _('UHF - Squelch OFF'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},
{down = device_commands.Button_10, cockpit_device_id  = devices.ARC164, value_down = 1, name = _('UHF - Squelch ON'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},

{down = device_commands.Button_52, cockpit_device_id  = devices.ARC164, value_down = -1, name = _('UHF - 0XX.XXX Decrease'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},
{down = device_commands.Button_52, cockpit_device_id  = devices.ARC164, value_down =  1, name = _('UHF - 0XX.XXX Increase'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},

{down = device_commands.Button_53, cockpit_device_id  = devices.ARC164, value_down = -1, name = _('UHF - X0X.XXX Decrease'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},
{down = device_commands.Button_53, cockpit_device_id  = devices.ARC164, value_down =  1, name = _('UHF - X0X.XXX Increase'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},

{down = device_commands.Button_54, cockpit_device_id  = devices.ARC164, value_down = -1, name = _('UHF - XX0.XXX Decrease'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},
{down = device_commands.Button_54, cockpit_device_id  = devices.ARC164, value_down =  1, name = _('UHF - XX0.XXX Increase'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},

{down = device_commands.Button_55, cockpit_device_id  = devices.ARC164, value_down = -1, name = _('UHF - XXX.0XX Decrease'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},
{down = device_commands.Button_55, cockpit_device_id  = devices.ARC164, value_down =  1, name = _('UHF - XXX.0XX Increase'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},

{down = device_commands.Button_56, cockpit_device_id  = devices.ARC164, value_down = -1, name = _('UHF - XXX.X00 Decrease'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},
{down = device_commands.Button_56, cockpit_device_id  = devices.ARC164, value_down =  1, name = _('UHF - XXX.X00 Increase'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},

{down = device_commands.Button_51, cockpit_device_id  = devices.ARC164, value_down = -1, name = _('UHF - Channel Decrease'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},
{down = device_commands.Button_51, cockpit_device_id  = devices.ARC164, value_down =  1, name = _('UHF - Channel Increase'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},

{down = device_commands.Button_58, cockpit_device_id  = devices.ARC164, value_down = -1, name = _('UHF - Main selector Decrease'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},
{down = device_commands.Button_58, cockpit_device_id  = devices.ARC164, value_down =  1, name = _('UHF - Main selector Increase'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},

{down = device_commands.Button_8, cockpit_device_id  = devices.ARC164, value_down =  0, name = _('UHF - Main selector OFF'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},
{down = device_commands.Button_8, cockpit_device_id  = devices.ARC164, value_down =  0.25, name = _('UHF - Main selector MAIN'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},
{down = device_commands.Button_8, cockpit_device_id  = devices.ARC164, value_down =  0.5, name = _('UHF - Main selector BOTH'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},
{down = device_commands.Button_8, cockpit_device_id  = devices.ARC164, value_down =  0.75, name = _('UHF - Main selector ADF'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},

{down = device_commands.Button_57, cockpit_device_id  = devices.ARC164, value_down = -1, name = _('UHF - Mode Decrease'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},
{down = device_commands.Button_57, cockpit_device_id  = devices.ARC164, value_down =  1, name = _('UHF - Mode Increase'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},

{down = device_commands.Button_7, cockpit_device_id  = devices.ARC164, value_down =  0, name = _('UHF - Mode MANUAL'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},
{down = device_commands.Button_7, cockpit_device_id  = devices.ARC164, value_down =  0.5, name = _('UHF - Mode PRESET'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},
{down = device_commands.Button_7, cockpit_device_id  = devices.ARC164, value_down =  1, name = _('UHF - Mode GUARD'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},

{pressed = device_commands.Button_61, cockpit_device_id  = devices.ARC164, value_pressed = -1, name = _('UHF - Volume Decrease'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},
{pressed = device_commands.Button_61, cockpit_device_id  = devices.ARC164, value_pressed =  1, name = _('UHF - Volume Increase'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},

{pressed = device_commands.Button_65, cockpit_device_id  = devices.ARC164, value_pressed = -1, name = _('UHF Cover Close'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},
{pressed = device_commands.Button_65, cockpit_device_id  = devices.ARC164, value_pressed =  1, name = _('UHF Cover Open'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},

{down = device_commands.Button_66, up = device_commands.Button_66, cockpit_device_id = devices.ARC164,value_down = 1,value_up = 0, name = _('UHF Preset Button'), category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)')}},

--Korry CAUTION, ANTISKID...
{down = device_commands.Button_16, up = device_commands.Button_16, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Fault Alert Reset'), category = _('Main instrument panel')},
{down = device_commands.Button_43, up = device_commands.Button_43, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Antiskid ON/OFF'), category = _('Main instrument panel')},
{down = device_commands.Button_17, up = device_commands.Button_17, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Fire Alert test'), category = _('Main instrument panel')},
{down = device_commands.Button_18, up = device_commands.Button_18, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Caution Alert Reset'), category = _('Main instrument panel')},


--HSI (course and heading)

{pressed = device_commands.Button_29, cockpit_device_id = devices.SYSTEMS, value_pressed = -0.005, name = _('Course Knob Decrease'), category = _('Main instrument panel')},
{pressed = device_commands.Button_29, cockpit_device_id = devices.SYSTEMS, value_pressed = 0.005, name = _('Course Knob Increase'), category = _('Main instrument panel')},

{pressed = device_commands.Button_30, cockpit_device_id = devices.SYSTEMS, value_pressed = -0.005, name = _('Heading Knob Decrease'), category = _('Main instrument panel')},
{pressed = device_commands.Button_30, cockpit_device_id = devices.SYSTEMS, value_pressed = 0.005, name = _('Heading Knob Increase'), category = _('Main instrument panel')},

--IFF
{down = device_commands.Button_218, up = device_commands.Button_218, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('IFF reply lamp test'), category = {_('Main instrument panel'), _('IFF panel')}},

{pressed = device_commands.Button_918, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('IFF Reply Test Lamp Increase'), category = {_('Main instrument panel'), _('IFF panel')}},
{pressed = device_commands.Button_918, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('IFF Reply Test Lamp Decrease'), category = {_('Main instrument panel'), _('IFF panel')}},

{down = device_commands.Button_219, up = device_commands.Button_219, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('IFF test'), category = {_('Main instrument panel'), _('IFF panel')}},

{pressed = device_commands.Button_919, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('IFF Test Light Increase'), category = {_('Main instrument panel'), _('IFF panel')}},
{pressed = device_commands.Button_919, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('IFF Test Light Decrease'), category = {_('Main instrument panel'), _('IFF panel')}},

{down = device_commands.Button_205,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Audio light switch - LIGHT'),		category = {_('Main instrument panel'), _('IFF panel')}},
{down = device_commands.Button_205,cockpit_device_id = devices.SYSTEMS,	value_down = 0.5,	name = _('Audio light switch - OUT'),	category = {_('Main instrument panel'), _('IFF panel')}},
{down = device_commands.Button_205,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Audio light switch - AUDIO'),	category = {_('Main instrument panel'), _('IFF panel')}},

{down = device_commands.Button_211,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('IFF Mode 4 - ON'),		category = {_('Main instrument panel'), _('IFF panel')}},
{down = device_commands.Button_211,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('IFF Mode 4 - OUT'),	category = {_('Main instrument panel'), _('IFF panel')}},

{down = device_commands.Button_206,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('TEST M-1 switch - M-1'),category = {_('Main instrument panel'), _('IFF panel')}},
{down = device_commands.Button_206,cockpit_device_id = devices.SYSTEMS,	value_down = 0.5,	name = _('TEST M-1 switch - ON'),	category = {_('Main instrument panel'), _('IFF panel')}},
{down = device_commands.Button_206,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('TEST M-1 switch - OUT'),category = {_('Main instrument panel'), _('IFF panel')}},

{down = device_commands.Button_207,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('TEST M-2 switch - M-2'),category = {_('Main instrument panel'), _('IFF panel')}},
{down = device_commands.Button_207,cockpit_device_id = devices.SYSTEMS,	value_down = 0.5,	name = _('TEST M-2 switch - ON'),	category = {_('Main instrument panel'), _('IFF panel')}},
{down = device_commands.Button_207,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('TEST M-2 switch - OUT'),category = {_('Main instrument panel'), _('IFF panel')}},

{down = device_commands.Button_208,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('TEST M-3/A switch - M-3/A'),category = {_('Main instrument panel'), _('IFF panel')}},
{down = device_commands.Button_208,cockpit_device_id = devices.SYSTEMS,	value_down = 0.5,	name = _('TEST M-3/A switch - ON'),	category = {_('Main instrument panel'), _('IFF panel')}},
{down = device_commands.Button_208,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('TEST M-3/A switch - OUT'),category = {_('Main instrument panel'), _('IFF panel')}},

{down = device_commands.Button_209,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('TEST M-C switch - M-C'),category = {_('Main instrument panel'), _('IFF panel')}},
{down = device_commands.Button_209,cockpit_device_id = devices.SYSTEMS,	value_down = 0.5,	name = _('TEST M-C switch - ON'),	category = {_('Main instrument panel'), _('IFF panel')}},
{down = device_commands.Button_209,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('TEST M-C switch - OUT'),category = {_('Main instrument panel'), _('IFF panel')}},

{down = device_commands.Button_210,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('RAD TEST switch - RAD TEST'),category = {_('Main instrument panel'), _('IFF panel')}},
{down = device_commands.Button_210,cockpit_device_id = devices.SYSTEMS,	value_down = 0.5,	name = _('RAD TEST switch - OUT'),category = {_('Main instrument panel'), _('IFF panel')}},
{down = device_commands.Button_210,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('RAD TEST switch - MON'),	category = {_('Main instrument panel'), _('IFF panel')}},

{down = device_commands.Button_220,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('IDENT switch - IDENT'),category = {_('Main instrument panel'), _('IFF panel')}},
{down = device_commands.Button_220,cockpit_device_id = devices.SYSTEMS,	value_down = 0.5,	name = _('IDENT switch - OUT'),	category = {_('Main instrument panel'), _('IFF panel')}},
{down = device_commands.Button_220,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('IDENT switch - MIC'),category = {_('Main instrument panel'), _('IFF panel')}},

{down = device_commands.Button_715, cockpit_device_id = devices.SYSTEMS,value_down = 0.0, name = _('MODE 1 - X0 Decrease'), category = {_('Main instrument panel'), _('IFF panel')}},
{down = device_commands.Button_715, cockpit_device_id = devices.SYSTEMS,value_down = 1.0, name = _('MODE 1 - X0 Increase'), category = {_('Main instrument panel'), _('IFF panel')}},

{down = device_commands.Button_716, cockpit_device_id = devices.SYSTEMS,value_down = 0.0, name = _('MODE 1 - 0X Decrease'), category = {_('Main instrument panel'), _('IFF panel')}},
{down = device_commands.Button_716, cockpit_device_id = devices.SYSTEMS,value_down = 1.0, name = _('MODE 1 - 0X Increase'), category = {_('Main instrument panel'), _('IFF panel')}},

{down = device_commands.Button_717, cockpit_device_id = devices.SYSTEMS,value_down = 0.0, name = _('MODE 3 - X000 Decrease'), category = {_('Main instrument panel'), _('IFF panel')}},
{down = device_commands.Button_717, cockpit_device_id = devices.SYSTEMS,value_down = 1.0, name = _('MODE 3 - X000 Increase'), category = {_('Main instrument panel'), _('IFF panel')}},

{down = device_commands.Button_718, cockpit_device_id = devices.SYSTEMS,value_down = 0.0, name = _('MODE 3 - 0X00 Decrease'), category = {_('Main instrument panel'), _('IFF panel')}},
{down = device_commands.Button_718, cockpit_device_id = devices.SYSTEMS,value_down = 1.0, name = _('MODE 3 - 0X00 Increase'), category = {_('Main instrument panel'), _('IFF panel')}},

{down = device_commands.Button_719, cockpit_device_id = devices.SYSTEMS,value_down = 0.0, name = _('MODE 3 - 00X0 Decrease'), category = {_('Main instrument panel'), _('IFF panel')}},
{down = device_commands.Button_719, cockpit_device_id = devices.SYSTEMS,value_down = 1.0, name = _('MODE 3 - 00X0 Increase'), category = {_('Main instrument panel'), _('IFF panel')}},

{down = device_commands.Button_720, cockpit_device_id = devices.SYSTEMS,value_down = 0.0, name = _('MODE 3 - 000X Decrease'), category = {_('Main instrument panel'), _('IFF panel')}},
{down = device_commands.Button_720, cockpit_device_id = devices.SYSTEMS,value_down = 1.0, name = _('MODE 3 - 000X Increase'), category = {_('Main instrument panel'), _('IFF panel')}},

{down = device_commands.Button_721, cockpit_device_id = devices.SYSTEMS,value_down = 0.0, name = _('Master switch Decrease'), category = {_('Main instrument panel'), _('IFF panel')}},
{down = device_commands.Button_721, cockpit_device_id = devices.SYSTEMS,value_down = 1.0, name = _('Master switch Increase'), category = {_('Main instrument panel'), _('IFF panel')}},

{down = device_commands.Button_722, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, name = _('Code select Decrease'), category = {_('Main instrument panel'), _('IFF panel')}},
{down = device_commands.Button_722, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, name = _('Code select Increase'), category = {_('Main instrument panel'), _('IFF panel')}},


--Adjust Rudder Pedals

{down = device_commands.Button_888, up= device_commands.Button_888, cockpit_device_id = devices.SYSTEMS,	value_down = -1.0, value_up= 1.0 ,name = _('Adjust Rudder Pedals Handle'),category = {_('Systems')}},
{pressed = device_commands.Button_890,cockpit_device_id = devices.SYSTEMS,	value_pressed = -1.0,	name = _('Adjust Rudder Pedals - Backward'),category = {_('Systems')}},
{pressed = device_commands.Button_890,cockpit_device_id = devices.SYSTEMS,	value_pressed = 1.0,	name = _('Adjust Rudder Pedals - Forward'),	category = {_('Systems')}},


--UFH Antenna, DME SELECTOR.....
{down = device_commands.Button_221,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('UHF Antenna selection - UP'),		category = {_('Main instrument panel')}},
{down = device_commands.Button_221,cockpit_device_id = devices.SYSTEMS,	value_down = 0.5,	name = _('UHF Antenna selection - AUT'),		category = {_('Main instrument panel')}},
{down = device_commands.Button_221,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('UHF Antenna selection - DOWN'),	category = {_('Main instrument panel')}},

{down = device_commands.Button_304, up = device_commands.Button_304, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Synchronizer Switch - CROSS'), category = _('Main instrument panel')},
{down = device_commands.Button_26, up = device_commands.Button_26, cockpit_device_id = devices.SYSTEMS,value_down = -1.0,value_up = 0.0, name = _('Synchronizer Switch - DOT'), category = _('Main instrument panel')},

{down = device_commands.Button_27, up = device_commands.Button_27, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Vertical gyro fast erect - ON'), category = _('Main instrument panel')},

{down = device_commands.Button_28,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Gyro mode - COMPASS'),		category = {_('Main instrument panel')}},
{down = device_commands.Button_28,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Gyro mode - GYRO'),	category = {_('Main instrument panel')}},

-------------------------------------------------------------Main Left panel-----------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------

--Anti-Rain
{down = device_commands.Button_222, up = device_commands.Button_222, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Anti-Rain fluid'), category = _('Main instrument panel')},

--landing light
{down = device_commands.Button_109,cockpit_device_id = devices.LIGHTS,	value_down = 1.0,	name = _('Left spotlight switch - LAND'),		category = {_('Main instrument panel'), _('Illumination')}},
{down = device_commands.Button_109,cockpit_device_id = devices.LIGHTS,	value_down = 0.5,	name = _('Left spotlight switch - TAXI'),	category = {_('Main instrument panel'), _('Illumination')}},
{down = device_commands.Button_109,cockpit_device_id = devices.LIGHTS,	value_down = 0.0,	name = _('Left spotlight switch - OFF'),	category = {_('Main instrument panel'), _('Illumination')}},
{down = device_commands.Button_110,cockpit_device_id = devices.LIGHTS,	value_down = 1.0,	name = _('Right spotlight switch - LAND'),		category = {_('Main instrument panel'), _('Illumination')}},
{down = device_commands.Button_110,cockpit_device_id = devices.LIGHTS,	value_down = 0.5,	name = _('Right spotlight switch - TAXI'),	category = {_('Main instrument panel'), _('Illumination')}},
{down = device_commands.Button_110,cockpit_device_id = devices.LIGHTS,	value_down = 0.0,	name = _('Right spotlight switch - OFF'),	category = {_('Main instrument panel'), _('Illumination')}},

--Pitot heat
{down = device_commands.Button_201, up = device_commands.Button_201, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Pitot heat'), category = _('Main instrument panel')},

--Stall
{down = device_commands.Button_199, up = device_commands.Button_199, cockpit_device_id = devices.SYSTEMS,value_down = -1.0,value_up = 0.0, name = _('Stall warning test - RESET'), category = _('Main instrument panel')},
{down = device_commands.Button_223, up = device_commands.Button_223, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Stall warning test - TEST'), category = _('Main instrument panel')},
{down = device_commands.Button_200,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Stall warning Power - OFF'),		category = {_('Main instrument panel')}},
{down = device_commands.Button_200,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Stall warning Power - ON'),	category = {_('Main instrument panel')}},

--landing gear override
{down = device_commands.Button_232, up = device_commands.Button_232, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Landing gear override'), category = _('Main instrument panel')},

--Parking brake
{down = 8023, cockpit_device_id = devices.SYSTEMS, name = "Parking Brake", category =_('Systems')},

--Gear Lever
{down = 8005, cockpit_device_id = devices.SYSTEMS, name = "Landing Gear Toggle", category = _('Systems')},
{down = 8029, cockpit_device_id = devices.SYSTEMS, name = _("Landing gear up"), category =_('Systems')},
{down = 8030, cockpit_device_id = devices.SYSTEMS, name = _("Landing gear down"), category =_('Systems')},

-------------------------------------------------------------Main Right panel-----------------------------------------------------
----------------------------------------------------------------------------------------------------------------------------------
--Batteries
{down = device_commands.Button_1,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Battery master switch - ON'),category = {_('Main instrument panel'), _('Electrical system panel')}},
{down = device_commands.Button_1,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Battery master switch - OFF'),	category = {_('Main instrument panel'), _('Electrical system panel')}},

{down = device_commands.Button_3, up = device_commands.Button_3, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Left Battery Isolation switch'), category = {_('Main instrument panel'), _('Electrical system panel')}},

{down = device_commands.Button_5, up = device_commands.Button_5, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Right Battery Isolation switch'), category = {_('Main instrument panel'), _('Electrical system panel')}},

--Bus Tie
{down = device_commands.Button_6,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('DC Bus Tie - ON'),category = {_('Main instrument panel'), _('Electrical system panel')}},
{down = device_commands.Button_6,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('DC Bus Tie - OFF'),category = {_('Main instrument panel'), _('Electrical system panel')}},

--Generator
{down = device_commands.Button_300, up = device_commands.Button_300, cockpit_device_id = devices.SYSTEMS,value_down = -1.0,value_up = 0.0, name = _('Generator - RESET'), category = {_('Main instrument panel'), _('Electrical system panel')}},
{down = device_commands.Button_10,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Generator - OFF'),		category = {_('Main instrument panel'), _('Electrical system panel')}},
{down = device_commands.Button_10,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Generator - ON'),	category = {_('Main instrument panel'), _('Electrical system panel')}},

{down = device_commands.Button_301, up = device_commands.Button_301, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Generator ground Fault'), category = {_('Main instrument panel'), _('Electrical system panel')}},
{down = device_commands.Button_11, up = device_commands.Button_11, cockpit_device_id = devices.SYSTEMS,value_down = -1.0,value_up = 0.0, name = _('Generator ground Overvoltage'), category = {_('Main instrument panel'), _('Electrical system panel')}},

--ESS BUS Transfer
{down = device_commands.Button_8, up = device_commands.Button_8, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('ESS BUS Transfer'), category = {_('Main instrument panel'), _('Electrical system panel')}},

--inverter
{down = device_commands.Button_9,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('AC inverter Norm/Alt - NORMAL'),		category = {_('Main instrument panel'), _('Electrical system panel')}},
{down = device_commands.Button_9,cockpit_device_id = devices.SYSTEMS,	value_down = 0.5,	name = _('AC inverter Norm/Alt - OFF'),	category = {_('Main instrument panel'), _('Electrical system panel')}},
{down = device_commands.Button_9,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('AC inverter Norm/Alt - INVERTER'),		category = {_('Main instrument panel'), _('Electrical system panel')}},

--Warning/Caution
{down = device_commands.Button_12,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CAWS Panel Bright'),		category = {_('Main instrument panel')}},
{down = device_commands.Button_12,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CAWS Panel Dim'),	category = {_('Main instrument panel')}},
{down = device_commands.Button_13, up= device_commands.Button_13, cockpit_device_id = devices.SYSTEMS,	value_down = 1.0, value_up= 0.0 ,name = _('Lamp test'),category = {_('Main instrument panel')}},

-------------------------------------------------------------Left Console----------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------
--Fuel panel
{down = device_commands.Button_46, up = device_commands.Button_46, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Fuselage tank Pump'), category = {_('Left Console'), _('Fuel panel')}},

{down = device_commands.Button_47, up = device_commands.Button_47, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Engine Fuel Valve'), category = {_('Left Console'), _('Fuel panel')}},

{down = device_commands.Button_48, up = device_commands.Button_48, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Center wing tank Qty'), category = {_('Left Console'), _('Fuel panel')}},

{down = device_commands.Button_49, up = device_commands.Button_49, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Test fuel Qty indicator'), category = {_('Left Console'), _('Fuel panel')}},

{down = device_commands.Button_50,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Fuel Transfer Left AUT'),	category = {_('Left Console'), _('Fuel panel')}},
{down = device_commands.Button_50,cockpit_device_id = devices.SYSTEMS,	value_down = 0.5,	name = _('Fuel Transfer Left OFF'),	category = {_('Left Console'), _('Fuel panel')}},
{down = device_commands.Button_50,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Fuel Transfer Left MAN'),	category = {_('Left Console'), _('Fuel panel')}},

{down = device_commands.Button_51,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Fuel Transfer Center 1 AUT'),	category = {_('Left Console'), _('Fuel panel')}},
{down = device_commands.Button_51,cockpit_device_id = devices.SYSTEMS,	value_down = 0.5,	name = _('Fuel Transfer Center 1 OFF'),	category = {_('Left Console'), _('Fuel panel')}},
{down = device_commands.Button_51,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Fuel Transfer Center 1 MAN'),	category = {_('Left Console'), _('Fuel panel')}},

{down = device_commands.Button_52,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Fuel Transfer Center 2 AUT'),	category = {_('Left Console'), _('Fuel panel')}},
{down = device_commands.Button_52,cockpit_device_id = devices.SYSTEMS,	value_down = 0.5,	name = _('Fuel Transfer Center 2 OFF'),	category = {_('Left Console'), _('Fuel panel')}},
{down = device_commands.Button_52,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Fuel Transfer Center 2 MAN'),	category = {_('Left Console'), _('Fuel panel')}},

{down = device_commands.Button_53,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Fuel Transfer Right AUT'),	category = {_('Left Console'), _('Fuel panel')}},
{down = device_commands.Button_53,cockpit_device_id = devices.SYSTEMS,	value_down = 0.5,	name = _('Fuel Transfer Right OFF'),	category = {_('Left Console'), _('Fuel panel')}},
{down = device_commands.Button_53,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Fuel Transfer Right MAN'),	category = {_('Left Console'), _('Fuel panel')}},

--Engine panel
--{down = 8002, cockpit_device_id = devices.SYSTEMS, name = "GPU Connection", category = 'External GPU'},
{down = device_commands.Button_38, up = device_commands.Button_38, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('GPU on/off'), category = {_('Left Console'), _('Engine control panel'), _('External GPU')}},

{down = device_commands.Button_112, up = device_commands.Button_112, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Anti-Ice'), category = {_('Left Console'), _('Engine control panel')}},

{down = device_commands.Button_111, up = device_commands.Button_111, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Computer'), category = {_('Left Console'), _('Engine control panel')}},

{down = device_commands.Button_115, up = device_commands.Button_115, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, value_up = 0.0, name = _("Ignition Mode Selector - START"), category = {_('Left Console'), _('Engine control panel')}},
{down = device_commands.Button_115, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, name = _("Ignition Mode Selector - OFF"), category = {_('Left Console'), _('Engine control panel')}},
{down = device_commands.Button_115, cockpit_device_id = devices.SYSTEMS, value_down = -1.0, name = _("Ignition Mode Selector - CONTINUOUS"), category = {_('Left Console'), _('Engine control panel')}},

{down = device_commands.Button_114, up = device_commands.Button_114, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Abort'), category = {_('Left Console'), _('Engine control panel')}},

{down = device_commands.Button_116, up = device_commands.Button_116, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Ignition light test'), category = {_('Left Console'), _('Engine control panel')}},

{pressed = device_commands.Button_914, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('Ignition Dimmer Increase'), category = {_('Left Console'), _('Engine control panel')}},
{pressed = device_commands.Button_914, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('Ignition Dimmer Decrease'), category = {_('Left Console'), _('Engine control panel')}},

{down = device_commands.Button_113, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, name = _("Starter Mode Selector Crank"), category ={_('Left Console'), _('Engine control panel')}},
{down = device_commands.Button_113, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, name = _("Starter Mode Selector Normal"), category ={_('Left Console'), _('Engine control panel')}},

--Throttle panel
{down = 8006, cockpit_device_id = devices.SYSTEMS, name = _("Next Flap Detent"), category ={_('Left Console'), _('Throttle panel'), _('Flight Control')}},
{down = 8007, cockpit_device_id = devices.SYSTEMS, name = _("Prev Flap Detent"), category ={_('Left Console'), _('Throttle panel'), _('Flight Control')}},

{down = 8008, up = 8010, cockpit_device_id = devices.SYSTEMS, name = _("HOTAS Flaps Up"), category ={_('Left Console'), _('Throttle panel'), _('Flight Control')}},
{down = 8009, up = 8010, cockpit_device_id = devices.SYSTEMS, name = _("HOTAS Flaps Down"), category ={_('Left Console'), _('Throttle panel'), _('Flight Control')}},

{down = 8008, cockpit_device_id = devices.SYSTEMS, name = _("Flaps Up"), category ={_('Left Console'), _('Throttle panel'), _('Flight Control')}},
{down = 8009, cockpit_device_id = devices.SYSTEMS, name = _("Flaps Down"), category ={_('Left Console'), _('Throttle panel'), _('Flight Control')}},
{down = 8010, cockpit_device_id = devices.SYSTEMS, name = _("Flaps Middle"), category ={_('Left Console'), _('Throttle panel'), _('Flight Control')}},

{down = 8011, cockpit_device_id = devices.SYSTEMS, name = _("Toggle Flaps - one step up/down"), category ={_('Left Console'), _('Throttle panel'), _('Flight Control')}},

{down = 8014, cockpit_device_id = devices.SYSTEMS, name = _("Throttle Idle Detent - Idle/Stop (toggle button)"), category ={_('Left Console'), _('Throttle lever'), _('Flight Control')}},
{down = device_commands.Button_118, up = device_commands.Button_118, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, value_up = 0.5, name = _("Throttle Idle Detent - Idle/Stop (2 pos switch)"), category ={_('Left Console'), _('Throttle lever'), _('Flight Control')}},
{down = device_commands.Button_118, cockpit_device_id = devices.SYSTEMS, value_down = 0.5, name = _("Throttle Idle Detent - Idle"), category ={_('Left Console'), _('Throttle lever'), _('Flight Control')}},
{down = device_commands.Button_118, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, name = _("Throttle Idle Detent - Stop"), category ={_('Left Console'), _('Throttle lever'), _('Flight Control')}},
{pressed = device_commands.Button_251, cockpit_device_id = devices.SYSTEMS, value_pressed = -1.0, name = _("C-101 Throttle Friction Increase"), category ={_('Left Console'), _('Throttle panel')}},
{pressed = device_commands.Button_251, cockpit_device_id = devices.SYSTEMS, value_pressed = 1.0, name = _("C-101 Throttle Friction Decrease"), category ={_('Left Console'), _('Throttle panel')}},

--[[
{down = 8011, up = 8013, cockpit_device_id = devices.SYSTEMS, name = _('Air brake - Extend'), category =_('Flight Control')},
{down = 8012, up = 8013, cockpit_device_id = devices.SYSTEMS, name = _('Air brake - Retract'), category =_('Flight Control')},
]]

{down = iCommandPlaneAirBrake, cockpit_device_id = devices.SYSTEMS, name = _('Air brake - Extend/Retract'), category ={_('Left Console'), _('Throttle lever'), _('Flight Control')}},
{down = iCommandPlaneAirBrakeOn, up = 8013, cockpit_device_id = devices.SYSTEMS, name = _('Air brake - Extend'), category ={_('Left Console'), _('Throttle lever'), _('Flight Control')}},
{down = iCommandPlaneAirBrakeOff, up = 8013, cockpit_device_id = devices.SYSTEMS, name = _('Air brake - Retract'), category ={_('Left Console'), _('Throttle lever'), _('Flight Control')}},

{combos = {{key = 'G', reformers = {'LAlt'}}},	down = device_commands.Button_202, up= device_commands.Button_202, cockpit_device_id = devices.SYSTEMS,	value_down = 1.0, value_up= 0.0 ,name = _('Landing gear warning mute'),category = {_('Left Console'), _('Throttle panel')}},

{down = device_commands.Button_903, up = device_commands.Button_903, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = ('Fuel Enrichment'), category = {_('Left Console'), _('Throttle lever'), _('Flight Control')}},

--Emergency panel /Fuel
{down = device_commands.Button_160,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Pitch trim breaker - OFF'),	category = {_('Left Console'), _('Emergency panel')}},
{down = device_commands.Button_160,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Pitch trim breaker - ON'),	category = {_('Left Console'), _('Emergency panel')}},

{down = device_commands.Button_158,up = device_commands.Button_158, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, value_up=0.0,	name = _('Emergency Pitch Trim Lamp Test'),category = {_('Left Console'), _('Emergency panel')}},

{pressed = device_commands.Button_920, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('Emergency Pitch Trim Dimmer Increase'), category = {_('Left Console'), _('Emergency panel')}},
{pressed = device_commands.Button_920, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('Emergency Pitch Trim Dimmer Decrease'), category = {_('Left Console'), _('Emergency panel')}},

{down = device_commands.Button_151,up = device_commands.Button_151, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, value_up=0.0,	name = _('Emergency air brake retract'),category = {_('Left Console'), _('Emergency panel')}},

{down = device_commands.Button_153,up = device_commands.Button_153, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, value_up=0.0,	name = _('Aileron HYD override'),category = {_('Left Console'), _('Emergency panel')}},

{down = device_commands.Button_159,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Emergency landing gear extension - Extend'),	category = {_('Left Console'), _('Emergency panel')}},

{down = device_commands.Button_236,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Pitch trim tone mute - OFF'),	category = {_('Left Console'), _('Emergency panel')}},
{down = device_commands.Button_236,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Pitch trim tone mute - ON'),	category = {_('Left Console'), _('Emergency panel')}},

{down = device_commands.Button_156,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Pitch trim cutout guard OPEN'),	category = {_('Left Console'), _('Emergency panel')}},
{down = device_commands.Button_156,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Pitch trim cutout guard CLOSE'),	category = {_('Left Console'), _('Emergency panel')}},

{down = device_commands.Button_302,up = device_commands.Button_302, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, value_up=0.0,	name = _('Pitch trim cutout DOWN'),category = {_('Left Console'), _('Emergency panel')}},
{down = device_commands.Button_157,up = device_commands.Button_157, cockpit_device_id = devices.SYSTEMS, value_down =-1.0, value_up=0.0,	name = _('Pitch trim cutout UP'),category = {_('Left Console'), _('Emergency panel')}},

{down = 8024, up = 8026, cockpit_device_id = devices.SYSTEMS, name = _("Seat adjustment up"), category = {_('Left Console'), _('Emergency panel')}},
{down = 8025, up = 8026, cockpit_device_id = devices.SYSTEMS, name = _("Seat adjustment down"), category = {_('Left Console'), _('Emergency panel')}},


--Breakers panel
{down = device_commands.Button_54,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB engine generator - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_54,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB engine generator - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_55,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Normal inverter - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_55,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Normal inverter - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_56,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Backup inverter - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_56,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Backup inverter - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_57,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB CAUTION/WARNING panel - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_57,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB CAUTION/WARNING panel - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_58,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Landing gear - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_58,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Landing gear - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_59,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Backup ADI - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_59,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Backup ADI - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_60,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Fuel measuring system - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_60,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Fuel measuring system - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_61,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB RPM N1 - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_61,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB RPM N1 - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_62,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB RPM N2 - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_62,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB RPM N2 - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_63,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB ITT - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_63,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB ITT - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_64,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Vertical gyro DC - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_64,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Vertical gyro DC - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_65,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Directional gyro DC - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_65,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Directional gyro DC - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_66,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Vertical gyro AC - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_66,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Vertical gyro AC - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_67,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Directional gyro AC - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_67,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Directional gyro AC - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_68,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Landing Gear/Airbrake/Trim indicators - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_68,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Landing Gear/Airbrake/Trim indicators - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_69,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB OXY SYS/HYD SYS PRESS IND - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_69,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB OXY SYS/HYD SYS PRESS IND - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_70,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB VOR DC - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_70,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB VOR DC - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_71,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Air-Conditioning/Pressurization - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_71,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Air-Conditioning/Pressurization - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_72,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Air brake/Anti-Skid operation - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_72,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Air brake/Anti-Skid operation - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_73,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Oil Pressure - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_73,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Oil Pressure - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_74,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Fuselage tank pump - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_74,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Fuselage tank pump - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_75,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Center wing tank pumps - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_75,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Center wing tank pumps - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_76,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Outer wing tank pumps - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_76,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Outer wing tank pumps - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_77,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB TACAN DC - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_77,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB TACAN DC - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_80,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB TACAN AC 26 - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_80,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB TACAN AC 26 - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_81,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Oil temp IND - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_81,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Oil temp IND - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_101,cockpit_device_id = devices.SYSTEMS,value_down = 1.0,	name = _('CB LH land/taxi light - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_101,cockpit_device_id = devices.SYSTEMS,value_down = 0.0,	name = _('CB LH land/taxi light - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_89,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Position lights and RH land/taxi lights - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_89,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Position lights and RH land/taxi lights - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_90,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Red cockpit lighting - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_90,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Red cockpit lighting - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_94,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Instruments, storm and Anti-Collision lights - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_94,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Instruments, storm and Anti-Collision lights - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_98,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Formation lights - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_98,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Formation lights - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_99,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Console lights - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_99,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Console lights - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_84,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Flaps indicator and aileron indicator - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_84,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Flaps indicator and aileron indicator - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_87,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Engine computer - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_87,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Engine computer - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_85,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Engine starter - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_85,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Engine starter - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_91,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Fire detector - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_91,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Fire detector - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_95,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB UHF - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_95,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB UHF - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_100,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Flight Director - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_100,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Flight Director - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_97,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB IFF AC 115 - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_97,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB IFF AC 115 - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_82,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Pitot Heat/Stall warning system - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_82,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Pitot Heat/Stall warning system - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_83,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Anti-Ice/Rain repellent - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_83,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Anti-Ice/Rain repellent - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_86,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB IFF PRIM DC - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_86,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB IFF PRIM DC - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_88,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB elevator trim Power - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_88,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB elevator trim Power - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_92,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB VHF DC ESS - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_92,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB VHF DC ESS - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_93,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB interphone - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_93,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB interphone - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_96,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Seat adjustment - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_96,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Seat adjustment - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_643,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Colour Smoke - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_643,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Colour Smoke - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

{down = device_commands.Button_644,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB White Smoke - OUT'),	category = {_('Left Console'), _('Circuit breaker panel')}},
{down = device_commands.Button_644,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB White Smoke - IN'),	category = {_('Left Console'), _('Circuit breaker panel')}},

-------------------------------------------------------------Right Console-------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------------

--Illumination panel
{pressed = device_commands.Button_129, cockpit_device_id = devices.LIGHTS, value_pressed = -1, name = _('Instrument lighting Decrease'), category = {_('Right Console'), _('Illumination')}},
{pressed = device_commands.Button_129, cockpit_device_id = devices.LIGHTS, value_pressed = 1, name = _('Instrument lighting Increase'), category = {_('Right Console'), _('Illumination')}},

{pressed = device_commands.Button_127, cockpit_device_id = devices.LIGHTS, value_pressed = -1, name = _('Console integral lighting Decrease'), category = {_('Right Console'), _('Illumination')}},
{pressed = device_commands.Button_127, cockpit_device_id = devices.LIGHTS, value_pressed = 1, name = _('Console integral lighting Increase'), category = {_('Right Console'), _('Illumination')}},

{combos = {{key = 'J', reformers = {'RShift'}}},down = device_commands.Button_106,cockpit_device_id = devices.LIGHTS,	value_down = 1.0,	name = _('Anti-Collision beacon - ON'),	category = {_('Right Console'), _('Illumination')}},
{combos = {{key = 'J', reformers = {'RCtrl'}}},	down = device_commands.Button_106,cockpit_device_id = devices.LIGHTS,	value_down = 0.0,	name = _('Anti-Collision beacon - OFF'),	category = {_('Right Console'), _('Illumination')}},

{down = device_commands.Button_103,cockpit_device_id = devices.LIGHTS,	value_down = 1.0,	name = _('Storm lights - ON'),	category = {_('Right Console'), _('Illumination')}},
{down = device_commands.Button_103,cockpit_device_id = devices.LIGHTS,	value_down = 0.0,	name = _('Storm lights - OFF'),	category = {_('Right Console'), _('Illumination')}},

{combos = {{key = 'O', reformers = {'RShift'}}},	down = device_commands.Button_108,cockpit_device_id = devices.LIGHTS,	value_down = 1.0,	name = _('Formation lights - BRIGHT'),	category = {_('Right Console'), _('Illumination')}},
{combos = {{key = 'O', reformers = {'RCtrl'}}},	down = device_commands.Button_108,cockpit_device_id = devices.LIGHTS,	value_down = 0.5,	name = _('Formation lights - OFF'),	category = {_('Right Console'), _('Illumination')}},
{combos = {{key = 'O', reformers = {'RAlt'}}},	down = device_commands.Button_108,cockpit_device_id = devices.LIGHTS,	value_down = 0.0,	name = _('Formation lights - TENUE'),	category = {_('Right Console'), _('Illumination')}},

{combos = {{key = 'N', reformers = {'RShift'}}},	down = device_commands.Button_107,cockpit_device_id = devices.LIGHTS,	value_down = 1.0,	name = _('NAV lights - BRIGHT'),	category = {_('Right Console'), _('Illumination')}},
{combos = {{key = 'N', reformers = {'RCtrl'}}},	down = device_commands.Button_107,cockpit_device_id = devices.LIGHTS,	value_down = 0.5,	name = _('NAV lights - OFF'),	category = {_('Right Console'), _('Illumination')}},
{combos = {{key = 'N', reformers = {'RAlt'}}},	down = device_commands.Button_107,cockpit_device_id = devices.LIGHTS,	value_down = 0.0,	name = _('NAV lights - TENUE'),	category = {_('Right Console'), _('Illumination')}},

{down = device_commands.Button_102,cockpit_device_id = devices.LIGHTS,	value_down = 1.0,	name = _('Red flood lighting - BRIGHT'),	category = {_('Right Console'), _('Illumination')}},
{down = device_commands.Button_102,cockpit_device_id = devices.LIGHTS,	value_down = 0.5,	name = _('Red flood lighting - OFF'),	category = {_('Right Console'), _('Illumination')}},
{down = device_commands.Button_102,cockpit_device_id = devices.LIGHTS,	value_down = 0.0,	name = _('Red flood lighting - TENUE'),	category = {_('Right Console'), _('Illumination')}},

{down = device_commands.Button_252,cockpit_device_id = devices.LIGHTS,	value_down = 1.0,	name = _('Magnetic compass light - ON'),	category = {_('Right Console'), _('Illumination')}},
{down = device_commands.Button_252,cockpit_device_id = devices.LIGHTS,	value_down = 0.0,	name = _('Magnetic compass light - OFF'),	category = {_('Right Console'), _('Illumination')}},

--VOR/ILS/MB AN/ARN-127 panel
{down = device_commands.Button_51, up = device_commands.Button_51, cockpit_device_id = devices.ARN127,value_down = 1.0,value_up = 0.0, name = _('VOR-ILS-MB test VOR/MKR'), category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel')}},

{down = device_commands.Button_52, up = device_commands.Button_52, cockpit_device_id = devices.ARN127,value_down = 1.0,value_up = 0.0, name = _('VOR-ILS-MB test VHF NAV DIGITS'), category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel')}},

{pressed = device_commands.Button_53, cockpit_device_id  = devices.ARN127, value_pressed = -1.0, name = _('VOR/ILS Dimmer Decrease'), category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel')}},
{pressed = device_commands.Button_53, cockpit_device_id  = devices.ARN127, value_pressed = 1.0, name = _('VOR/ILS Dimmer Increase'), category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel')}},

{down = device_commands.Button_54, cockpit_device_id  = devices.ARN127, value_down = -1.0, name = _('VOR-ILS-MB (108-117) Decrease'), category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel')}},
{down = device_commands.Button_54, cockpit_device_id  = devices.ARN127, value_down = 1.0, name = _('VOR-ILS-MB (108-117) Increase'), category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel')}},

{down = device_commands.Button_55, cockpit_device_id  = devices.ARN127, value_down = -1.0, name = _('VOR-ILS-MB Frequency selector (0-9) Decrease'), category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel')}},
{down = device_commands.Button_55, cockpit_device_id  = devices.ARN127, value_down = 1.0, name = _('VOR-ILS-MB Frequency selector (0-9) Increase'), category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel')}},

{down = device_commands.Button_56, cockpit_device_id  = devices.ARN127, value_down = -1.0, name = _('VOR-ILS-MB Frequency selector (00/50) Decrease'), category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel')}},
{down = device_commands.Button_56, cockpit_device_id  = devices.ARN127, value_down = 1.0, name = _('VOR-ILS-MB Frequency selector (00/50) Increase'), category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel')}},

{pressed = device_commands.Button_57, cockpit_device_id  = devices.ARN127, value_pressed = -1.0, name = _('NAV VOL Decrease'), category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel')}},
{pressed = device_commands.Button_57, cockpit_device_id  = devices.ARN127, value_pressed = 1.0, name = _('NAV VOL Increase'), category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel')}},

--Tacan
{pressed = device_commands.Button_55, cockpit_device_id  = devices.ARN118, value_pressed = -1, name = _('TACAN Volume Decrease'), category = {_('Right Console'), _('TACAN AN/ARN-118 panel')}},
{pressed = device_commands.Button_55, cockpit_device_id  = devices.ARN118, value_pressed = 1, name = _('TACAN Volume Increase'), category = {_('Right Console'), _('TACAN AN/ARN-118 panel')}},

{down = device_commands.Button_4, up = device_commands.Button_4, cockpit_device_id = devices.ARN118,value_down = 1.0,value_up = 0.0, name = _('TACAN test'), category = {_('Right Console'), _('TACAN AN/ARN-118 panel')}},

{down = device_commands.Button_1, cockpit_device_id  = devices.ARN118, value_down = -1.0, name = _('TACAN 0x-9x Decrease'), category = {_('Right Console'), _('TACAN AN/ARN-118 panel')}},
{down = device_commands.Button_1, cockpit_device_id  = devices.ARN118, value_down = 1.0, name = _('TACAN 0x-9x Increase'), category = {_('Right Console'), _('TACAN AN/ARN-118 panel')}},

{down = device_commands.Button_2, cockpit_device_id  = devices.ARN118, value_down = -1.0, name = _('TACAN 0-9 Decrease'), category = {_('Right Console'), _('TACAN AN/ARN-118 panel')}},
{down = device_commands.Button_2, cockpit_device_id  = devices.ARN118, value_down = 1.0, name = _('TACAN 0-9 Increase'), category = {_('Right Console'), _('TACAN AN/ARN-118 panel')}},

{down = device_commands.Button_3, cockpit_device_id  = devices.ARN118, value_down = -1.0, name = _('TACAN X/Y Decrease'), category = {_('Right Console'), _('TACAN AN/ARN-118 panel')}},
{down = device_commands.Button_3, cockpit_device_id  = devices.ARN118, value_down = 1.0, name = _('TACAN X/Y Increase'), category = {_('Right Console'), _('TACAN AN/ARN-118 panel')}},

{down = device_commands.Button_56, cockpit_device_id  = devices.ARN118, value_down = -1, name = _('TACAN Mode Decrease'), category = {_('Right Console'), _('TACAN AN/ARN-118 panel')}},
{down = device_commands.Button_56, cockpit_device_id  = devices.ARN118, value_down = 1, name = _('TACAN Mode Increase'), category = {_('Right Console'), _('TACAN AN/ARN-118 panel')}},

{down = device_commands.Button_6, cockpit_device_id  = devices.ARN118, value_down = 0, name = _('TACAN Mode OFF'), category = {_('Right Console'), _('TACAN AN/ARN-118 panel')}},
{down = device_commands.Button_6, cockpit_device_id  = devices.ARN118, value_down = 0.25, name = _('TACAN Mode REC'), category = {_('Right Console'), _('TACAN AN/ARN-118 panel')}},
{down = device_commands.Button_6, cockpit_device_id  = devices.ARN118, value_down = 0.5, name = _('TACAN Mode T/R'), category = {_('Right Console'), _('TACAN AN/ARN-118 panel')}},
{down = device_commands.Button_6, cockpit_device_id  = devices.ARN118, value_down = 0.75, name = _('TACAN Mode A/A REC'), category = {_('Right Console'), _('TACAN AN/ARN-118 panel')}},
{down = device_commands.Button_6, cockpit_device_id  = devices.ARN118, value_down = 1, name = _('TACAN Mode A/A T/R'), category = {_('Right Console'), _('TACAN AN/ARN-118 panel')}},

--Intercom
{down = device_commands.Button_51, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('INTERCOM Volume PUSH'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{down = device_commands.Button_51, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('INTERCOM Volume PULL'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{pressed = device_commands.Button_52, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('INTERCOM Volume Decrease'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{pressed = device_commands.Button_52, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('INTERCOM Volume Increase'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{down = device_commands.Button_53, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('VHF Volume PUSH'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{down = device_commands.Button_53, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('VHF Volume PULL'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{pressed = device_commands.Button_54, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('VHF Volume Decrease'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{pressed = device_commands.Button_54, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('VHF Volume Increase'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{down = device_commands.Button_55, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('HOT MIC RX Volume PUSH'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{down = device_commands.Button_55, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('HOT MIC RX Volume PULL'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{pressed = device_commands.Button_56, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('HOT MIC RX Volume Decrease'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{pressed = device_commands.Button_56, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('HOT MIC RX Volume Increase'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{down = device_commands.Button_57, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('VOR Volume PUSH'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{down = device_commands.Button_57, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('VOR Volume PULL'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{pressed = device_commands.Button_58, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('VOR Volume Decrease'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{pressed = device_commands.Button_58, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('VOR Volume Increase'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{down = device_commands.Button_59, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('Marker Beacon Volume PUSH'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{down = device_commands.Button_59, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('Marker Beacon Volume PULL'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{pressed = device_commands.Button_60, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('Marker Beacon Volume Decrease'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{pressed = device_commands.Button_60, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('Marker Beacon Volume Increase'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{down = device_commands.Button_61, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('HOT MIC TX Volume PUSH'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{down = device_commands.Button_61, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('HOT MIC TX Volume PULL'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{down = device_commands.Button_62, up = device_commands.Button_62, cockpit_device_id = devices.INTERCOM,value_down = 1.0,value_up = 0.0, name = _('INTERCOM call button'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{pressed = device_commands.Button_63, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('INTERCOM master volume knob Decrease'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{pressed = device_commands.Button_63, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('INTERCOM master volume knob Increase'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{down = device_commands.Button_64, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('UHF Volume PUSH'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{down = device_commands.Button_64, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('UHF Volume PULL'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{pressed = device_commands.Button_65, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('UHF Volume Decrease'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{pressed = device_commands.Button_65, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('UHF Volume Increase'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{down = device_commands.Button_66, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('TACAN Volume PUSH'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{down = device_commands.Button_66, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('TACAN Volume PULL'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{pressed = device_commands.Button_67, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('TACAN Volume in Intercom Decrease'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{pressed = device_commands.Button_67, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('TACAN Volume in Intercom Increase'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{down = device_commands.Button_68, cockpit_device_id  = devices.INTERCOM, value_down = -1, name = _('INTERCOM Main mode selector Decrease'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{down = device_commands.Button_68, cockpit_device_id  = devices.INTERCOM, value_down = 1, name = _('INTERCOM Main mode selector Increase'), category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_100, up = device_commands.Button_100, cockpit_device_id  = devices.INTERCOM, value_down = 1, value_up = 0, name = _('VoIP PTT button (custom)'), category = {_('Left Console'), _('Throttle lever')}},

--VHF Radio AN/ARC-134 panel
{down = device_commands.Button_51, cockpit_device_id  = devices.ARC134, value_down = 0.0, name = _('VHF power switch ON'), category = {_('Right Console'), _('VHF radio AN/ARC-134 panel')}},
{down = device_commands.Button_51, cockpit_device_id  = devices.ARC134, value_down = 1.0, name = _('VHF power switch OFF'), category = {_('Right Console'), _('VHF radio AN/ARC-134 panel')}},

{down = device_commands.Button_52, cockpit_device_id  = devices.ARC134, value_down = -1, name = _('VHF Frequency selector (X0X.XXX) Decrease'), category = {_('Right Console'), _('VHF radio AN/ARC-134 panel')}},
{down = device_commands.Button_52, cockpit_device_id  = devices.ARC134, value_down = 1, name = _('VHF Frequency selector (X0X.XXX) Increase'), category = {_('Right Console'), _('VHF radio AN/ARC-134 panel')}},

{down = device_commands.Button_53, cockpit_device_id  = devices.ARC134, value_down = -1, name = _('VHF Frequency selector (XX0.XXX) Decrease'), category = {_('Right Console'), _('VHF radio AN/ARC-134 panel')}},
{down = device_commands.Button_53, cockpit_device_id  = devices.ARC134, value_down = 1, name = _('VHF Frequency selector (XX0.XXX) Increase'), category = {_('Right Console'), _('VHF radio AN/ARC-134 panel')}},

{down = device_commands.Button_54, cockpit_device_id  = devices.ARC134, value_down = -1, name = _('VHF Frequency selector (XXX.0XX) Decrease'), category = {_('Right Console'), _('VHF radio AN/ARC-134 panel')}},
{down = device_commands.Button_54, cockpit_device_id  = devices.ARC134, value_down = 1, name = _('VHF Frequency selector (XXX.0XX) Increase'), category = {_('Right Console'), _('VHF radio AN/ARC-134 panel')}},

{down = device_commands.Button_55, cockpit_device_id  = devices.ARC134, value_down = -1, name = _('VHF Frequency selector (XXX.X00) Decrease'), category = {_('Right Console'), _('VHF radio AN/ARC-134 panel')}},
{down = device_commands.Button_55, cockpit_device_id  = devices.ARC134, value_down = 1, name = _('VHF Frequency selector (XXX.X00) Increase'), category = {_('Right Console'), _('VHF radio AN/ARC-134 panel')}},

{down = device_commands.Button_56, up = device_commands.Button_56, cockpit_device_id = devices.ARC134,value_down = 1.0,value_up = 0.0, name = _('Display test'), category = {_('Right Console'), _('VHF radio AN/ARC-134 panel')}},

{pressed = device_commands.Button_57, cockpit_device_id  = devices.ARC134, value_pressed = -1, name = _('VHF dimmer Decrease'), category = {_('Right Console'), _('VHF radio AN/ARC-134 panel')}},
{pressed = device_commands.Button_57, cockpit_device_id  = devices.ARC134, value_pressed = 1, name = _('VHF dimmer Increase'), category = {_('Right Console'), _('VHF radio AN/ARC-134 panel')}},

{pressed = device_commands.Button_58, cockpit_device_id  = devices.ARC134, value_pressed = -1, name = _('VHF COMM Volume Decrease'), category = {_('Right Console'), _('VHF radio AN/ARC-134 panel')}},
{pressed = device_commands.Button_58, cockpit_device_id  = devices.ARC134, value_pressed = 1, name = _('VHF COMM Volume Increase'), category = {_('Right Console'), _('VHF radio AN/ARC-134 panel')}},

--Air conditioning

{down = device_commands.Button_120,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Air-Conditioning master switch - ON'),	category = {_('Right Console'), _('Air conditioning panel')}},
{down = device_commands.Button_120,cockpit_device_id = devices.SYSTEMS,	value_down = 0.5,	name = _('Air-Conditioning master switch - OFF'),	category = {_('Right Console'), _('Air conditioning panel')}},
{down = device_commands.Button_120, up = device_commands.Button_120, cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	value_up = 0.5, name = _('Air-Conditioning master switch - RESET'),	category = {_('Right Console'), _('Air conditioning panel')}},

{down = device_commands.Button_125, up = device_commands.Button_125, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Manual temperature control - COLD'), category = _('Right Console')},
{down = device_commands.Button_131, up = device_commands.Button_131, cockpit_device_id = devices.SYSTEMS,value_down = -1.0,value_up = 0.0, name = _('Manual temperature control - WARM'), category = _('Right Console')},

{down = device_commands.Button_121,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Air flow mode - COCKPIT'),	category = {_('Right Console'), _('Air conditioning panel')}},
{down = device_commands.Button_121,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Air flow mode - WINDSHIELD'),	category = {_('Right Console'), _('Air conditioning panel')}},

{down = device_commands.Button_123, cockpit_device_id = devices.SYSTEMS, value_down = 1.0,    name = _('Temperature mode AUTO'), category = {_('Right Console'), _('Air conditioning panel')}},
{down = device_commands.Button_123, cockpit_device_id = devices.SYSTEMS, value_down = 0.0,    name = _('Temperature mode Manual'), category = {_('Right Console'), _('Air conditioning panel')}},

{down = device_commands.Button_122, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, 	name = _('Emergency ventilation OFF'), category = {_('Right Console'), _('Air conditioning panel')}},
{down = device_commands.Button_122, cockpit_device_id = devices.SYSTEMS, value_down= 1.0, 	name = _('Emergency ventilation ON'), category = {_('Right Console'), _('Air conditioning panel')}},

{pressed = device_commands.Button_126, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('Temperature regulation control Decrease'), category = {_('Right Console'), _('Air conditioning panel')}},
{pressed = device_commands.Button_126, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('Temperature regulation control Increase'), category = {_('Right Console'), _('Air conditioning panel')}},

--Oxygen
{down = device_commands.Button_117,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Oxygen supply - ON'),	category = {_('Right Console'), _('Oxygen system')}},
{down = device_commands.Button_117,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Oxygen supply - OFF'),	category = {_('Right Console'), _('Oxygen system')}},

{down = device_commands.Button_996, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, name = _('Oxygen Regulator Control - 100%'),	category = {_('Ejection seat'), _('Oxygen system')}},
{down = device_commands.Button_996, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, name = _('Oxygen Regulator Control - AIRMIX'),	category = {_('Ejection seat'), _('Oxygen system')}},

--Map Case
{pressed = device_commands.Button_901,cockpit_device_id = devices.SYSTEMS,	value_pressed = 1.0,	name = _('Map Case Cover Open'),	category = {_('Right Console')}},
{pressed = device_commands.Button_901,cockpit_device_id = devices.SYSTEMS,	value_pressed = -1.0,	name = _('Map Case Cover Close'),	category = {_('Right Console')}},

-- Control Stick (miscellaneous buttons)
{down = device_commands.Button_905, up = device_commands.Button_905, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Rain Repelent'), category = {_('Control stick'), _('Systems')}},

{down = device_commands.Button_924, up = device_commands.Button_924, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Camera Button'), category = {_('Control stick'), _('Systems')}},

{down = device_commands.Button_926, up = device_commands.Button_926, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Stores Release Button (White Smoke)'), category = {_('Control stick'), _('Smoke System')}},

{down = device_commands.Button_928, cockpit_device_id = devices.SYSTEMS,value_down = 1.0, name = _('Stores Release Guard OPEN'), category = {_('Control stick'), _('Smoke System')}},
{combos = {}, down = device_commands.Button_928, cockpit_device_id = devices.SYSTEMS,value_down = 0.0, name = _('Stores Release Guard CLOSE'), category = {_('Control stick'), _('Smoke System')}},

{down = device_commands.Button_930, up = device_commands.Button_930, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Fixed Weapons Trigger (Smoke Colorant)'), category = {_('Control stick'), _('Smoke System')}},

{down = device_commands.Button_932, cockpit_device_id = devices.SYSTEMS,value_down = 1.0, name = _('Trigger Safety Catch UNLOCK'), category = {_('Control stick'), _('Smoke System')}},
{down = device_commands.Button_932, cockpit_device_id = devices.SYSTEMS,value_down = 0.0, name = _('Trigger Safety Catch LOCK'), category = {_('Control stick'), _('Smoke System')}},

-- Ejection handle
{down = device_commands.Button_245,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0, name = _('Ejection Seat Handle PULL'),	category = {_('Ejection seat'), _('Ejection system')}},
{down = device_commands.Button_245,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0, name = _('Ejection Seat Handle PUSH'),	category = {_('Ejection seat'), _('Ejection system')}},
{pressed = device_commands.Button_934,cockpit_device_id = devices.SYSTEMS,	value_pressed = -1.0,	name = _('Ejection Seat Handle Safety Pin INSTALL'),	category = {_('Ejection seat'), _('Ejection system')}},
{pressed = device_commands.Button_934,cockpit_device_id = devices.SYSTEMS,	value_pressed = 1.0,	name = _('Ejection Seat Handle Safety Pin REMOVE'),	category = {_('Ejection seat'), _('Ejection system')}},

-- Control Stick show/hide
{down = 8032, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, name = _('SHOW/HIDE FLIGHT STICK'), category = {_('Flight Control')}},

---------------------------------------------------------------------------------------------------------------------------------
-------------------------------------------------------------REAR COCKPIT--------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------

-------------------------------------------------------------Main panel----------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------
-- Flight director
{pressed = device_commands.Button_630, cockpit_device_id = devices.SYSTEMS, value_pressed = 1.0, name = _('FD Bright'), category = {_('Main instrument panel'), _('Rear Cockpit')}},
{pressed = device_commands.Button_630, cockpit_device_id = devices.SYSTEMS, value_pressed = 0.0, name = _('FD Dim'), category = {_('Main instrument panel'), _('Rear Cockpit')}},

--Altimeter
{pressed = device_commands.Button_20, cockpit_device_id = devices.SYSTEMS, value_pressed = -1.0, name = _('Altimeter pressure set Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{pressed = device_commands.Button_20, cockpit_device_id = devices.SYSTEMS, value_pressed = 1.0, name = _('Altimeter pressure set Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

--Fuel flow
{down = device_commands.Button_441, up = device_commands.Button_441, cockpit_device_id = devices.SYSTEMS,value_down = 0.0,value_up = 1.0, name = _('Fuel flow Reset')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

--Acceleration g units
{down = device_commands.Button_415, up = device_commands.Button_415, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Reset Max/Min Needles')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

--markers
{down = device_commands.Button_444, up = device_commands.Button_444, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Outer marker lamp test')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{down = device_commands.Button_445, up = device_commands.Button_445, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Middle marker lamp test')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{down = device_commands.Button_446, up = device_commands.Button_446, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Inner marker lamp test')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

{pressed = device_commands.Button_908, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('Outer Marker Dimmer Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{pressed = device_commands.Button_908, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('Outer Marker Dimmer Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

{pressed = device_commands.Button_910, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('Middle Marker Dimmer Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{pressed = device_commands.Button_910, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('Middle Marker Dimmer Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

{pressed = device_commands.Button_912, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('Inner Marker Dimmer Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{pressed = device_commands.Button_912, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('Inner Marker Dimmer Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

--Korry Buttons- UHF, VHF, NAV, TACAN/VOR
{down = device_commands.Button_641, up = device_commands.Button_641, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('VOR/TCN Nav Selector')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{down = device_commands.Button_485, up = device_commands.Button_485, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('NAV Priority')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{down = device_commands.Button_486, up = device_commands.Button_486, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('UHF Priority')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{down = device_commands.Button_487, up = device_commands.Button_487, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('VHF Priority')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

--HSI Bright
{pressed = device_commands.Button_447, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('HSI digit brightness Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{pressed = device_commands.Button_447, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('HSI digit brightness Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

--Air Speed
{pressed = device_commands.Button_491, cockpit_device_id = devices.SYSTEMS, value_pressed = -0.005, name = _('Airspeed indicator bug Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{pressed = device_commands.Button_491, cockpit_device_id = devices.SYSTEMS, value_pressed = 0.005, name = _('Airspeed indicator bug Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

--ADI
{down = device_commands.Button_688, up = device_commands.Button_688, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Attitude test')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

{pressed = device_commands.Button_182, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('ADI Pitch adjust Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{pressed = device_commands.Button_182, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('ADI Pitch adjust Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

--clock
{down = device_commands.Button_433, up = device_commands.Button_433, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Chronograph')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

{pressed = device_commands.Button_431, cockpit_device_id = devices.SYSTEMS, value_pressed = 0.0, name = _('Clock Setting Knob - PUSH')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{pressed = device_commands.Button_431, cockpit_device_id = devices.SYSTEMS, value_pressed = 1.0, name = _('Clock Setting Knob - PULL')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

{pressed = device_commands.Button_432, cockpit_device_id = devices.SYSTEMS, value_pressed = -0.008, name = _('Clock Setting Knob - Counterclockwise')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{pressed = device_commands.Button_432, cockpit_device_id = devices.SYSTEMS, value_pressed = 0.008, name = _('Clock Setting Knob - Clockwise')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

--Back Adi
{down = device_commands.Button_408, up = device_commands.Button_408, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Back up ADI Cage')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

{pressed = device_commands.Button_923, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('Pitch Reference Adjust Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{pressed = device_commands.Button_923, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('Pitch Reference Adjust Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

--UHF RADIO DIGITAL DISPLAY
{pressed = device_commands.Button_84, cockpit_device_id = devices.ARC164, value_pressed = -1, name = _('UHF Dimmer Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},
{pressed = device_commands.Button_84, cockpit_device_id = devices.ARC164, value_pressed =  1, name = _('UHF Dimmer Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},

{down = device_commands.Button_82, cockpit_device_id = devices.ARC164, value_down = 1, value_up = 0, name = _('UHF Digital display frequency mode')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},
{down = device_commands.Button_83, up = device_commands.Button_83, cockpit_device_id = devices.ARC164, value_down = 1, value_up = 0, name = _('UHF Digital display test')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},

--UHF RADIOS
{down = device_commands.Button_34, up = device_commands.Button_34, cockpit_device_id = devices.ARC164,value_down = 1,value_up = 0, name = _('UHF tone button')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},

{down = device_commands.Button_35, cockpit_device_id  = devices.ARC164, value_down = 0, name = _('UHF - Squelch OFF')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},
{down = device_commands.Button_35, cockpit_device_id  = devices.ARC164, value_down = 1, name = _('UHF - Squelch ON')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},

{down = device_commands.Button_72, cockpit_device_id  = devices.ARC164, value_down = -1, name = _('UHF - 0XX.XXX Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},
{down = device_commands.Button_72, cockpit_device_id  = devices.ARC164, value_down =  1, name = _('UHF - 0XX.XXX Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},

{down = device_commands.Button_73, cockpit_device_id  = devices.ARC164, value_down = -1, name = _('UHF - X0X.XXX Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},
{down = device_commands.Button_73, cockpit_device_id  = devices.ARC164, value_down =  1, name = _('UHF - X0X.XXX Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},

{down = device_commands.Button_74, cockpit_device_id  = devices.ARC164, value_down = -1, name = _('UHF - XX0.XXX Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},
{down = device_commands.Button_74, cockpit_device_id  = devices.ARC164, value_down =  1, name = _('UHF - XX0.XXX Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},

{down = device_commands.Button_75, cockpit_device_id  = devices.ARC164, value_down = -1, name = _('UHF - XXX.0XX Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},
{down = device_commands.Button_75, cockpit_device_id  = devices.ARC164, value_down =  1, name = _('UHF - XXX.0XX Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},

{down = device_commands.Button_76, cockpit_device_id  = devices.ARC164, value_down = -1, name = _('UHF - XXX.X00 Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},
{down = device_commands.Button_76, cockpit_device_id  = devices.ARC164, value_down =  1, name = _('UHF - XXX.X00 Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},

{down = device_commands.Button_71, cockpit_device_id  = devices.ARC164, value_down = -1, name = _('UHF - Channel Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},
{down = device_commands.Button_71, cockpit_device_id  = devices.ARC164, value_down =  1, name = _('UHF - Channel Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},

{down = device_commands.Button_78, cockpit_device_id  = devices.ARC164, value_down = -1, name = _('UHF - Main selector Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},
{down = device_commands.Button_78, cockpit_device_id  = devices.ARC164, value_down =  1, name = _('UHF - Main selector Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},

{down = device_commands.Button_33, cockpit_device_id  = devices.ARC164, value_down =  0, name = _('UHF - Main selector OFF')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},
{down = device_commands.Button_33, cockpit_device_id  = devices.ARC164, value_down =  0.25, name = _('UHF - Main selector MAIN')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},
{down = device_commands.Button_33, cockpit_device_id  = devices.ARC164, value_down =  0.5, name = _('UHF - Main selector BOTH')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},
{down = device_commands.Button_33, cockpit_device_id  = devices.ARC164, value_down =  0.75, name = _('UHF - Main selector ADF')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},

{down = device_commands.Button_77, cockpit_device_id  = devices.ARC164, value_down = -1, name = _('UHF - Mode Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},
{down = device_commands.Button_77, cockpit_device_id  = devices.ARC164, value_down =  1, name = _('UHF - Mode Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},

{down = device_commands.Button_32, cockpit_device_id  = devices.ARC164, value_down =  0, name = _('UHF - Mode MANUAL')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},
{down = device_commands.Button_32, cockpit_device_id  = devices.ARC164, value_down =  0.5, name = _('UHF - Mode PRESET')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},
{down = device_commands.Button_32, cockpit_device_id  = devices.ARC164, value_down =  1, name = _('UHF - Mode GUARD')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},

{pressed = device_commands.Button_81, cockpit_device_id  = devices.ARC164, value_pressed = -1, name = _('UHF - Volume Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},
{pressed = device_commands.Button_81, cockpit_device_id  = devices.ARC164, value_pressed =  1, name = _('UHF - Volume Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},

{pressed = device_commands.Button_85, cockpit_device_id  = devices.ARC164, value_pressed = -1, name = _('UHF Cover Close')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},
{pressed = device_commands.Button_85, cockpit_device_id  = devices.ARC164, value_pressed =  1, name = _('UHF Cover Open')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},

{down = device_commands.Button_86, up = device_commands.Button_86, cockpit_device_id = devices.ARC164,value_down = 1,value_up = 0, name = _('UHF Preset Button')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('UHF Radio AN/ARC-164(V)'), _('Rear Cockpit')}},

--Korry CAUTION, ANTISKID...
{down = device_commands.Button_412, up = device_commands.Button_412, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Fault Alert Reset')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{down = device_commands.Button_484, up = device_commands.Button_484, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Antiskid ON/OFF')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{down = device_commands.Button_413, up = device_commands.Button_413, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Fire Alert test')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{down = device_commands.Button_414, up = device_commands.Button_414, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Caution Alert Reset')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},


--HSI (course and heading)

{pressed = device_commands.Button_525, cockpit_device_id = devices.SYSTEMS, value_pressed = -0.005, name = _('Course Knob Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{pressed = device_commands.Button_525, cockpit_device_id = devices.SYSTEMS, value_pressed = 0.005, name = _('Course Knob Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

{pressed = device_commands.Button_526, cockpit_device_id = devices.SYSTEMS, value_pressed = -0.005, name = _('Heading Knob Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{pressed = device_commands.Button_526, cockpit_device_id = devices.SYSTEMS, value_pressed = 0.005, name = _('Heading Knob Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

--Adjust Rudder Pedals

{down = device_commands.Button_889, up= device_commands.Button_889, cockpit_device_id = devices.SYSTEMS,	value_down = -1.0, value_up= 1.0 ,name = _('Adjust Rudder Pedals Handle')..' '..rearCptSuffix,category = {_('Systems'), _('Rear Cockpit')}},
{pressed = device_commands.Button_891,cockpit_device_id = devices.SYSTEMS,	value_pressed = -1.0,	name = _('Adjust Rudder Pedals - Backward')..' '..rearCptSuffix,category = {_('Systems'), _('Rear Cockpit')}},
{pressed = device_commands.Button_891,cockpit_device_id = devices.SYSTEMS,	value_pressed = 1.0,	name = _('Adjust Rudder Pedals - Forward')..' '..rearCptSuffix,	category = {_('Systems'), _('Rear Cockpit')}},


--UHF Antenna, DME SELECTOR.....
{down = device_commands.Button_650, up = device_commands.Button_650, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.5, name = _('Synchronizer Switch - CROSS')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{down = device_commands.Button_650, up = device_commands.Button_650, cockpit_device_id = devices.SYSTEMS,value_down = 0.0,value_up = 0.5, name = _('Synchronizer Switch - DOT')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

{down = device_commands.Button_510, up = device_commands.Button_510, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Vertical gyro fast erect - ON')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

{down = device_commands.Button_642,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Gyro mode - COMPASS')..' '..rearCptSuffix,		category = {_('Main instrument panel'), _('Rear Cockpit')}},
{down = device_commands.Button_642,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Gyro mode - GYRO')..' '..rearCptSuffix,	category = {_('Main instrument panel'), _('Rear Cockpit')}},

-------------------------------------------------------------Main Left panel-----------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------

--landing light
{down = device_commands.Button_420,cockpit_device_id = devices.LIGHTS,	value_down = 1.0,	name = _('Left spotlight switch - LAND')..' '..rearCptSuffix,		category = {_('Main instrument panel'), _('Illumination'), _('Rear Cockpit')}},
{down = device_commands.Button_420,cockpit_device_id = devices.LIGHTS,	value_down = 0.0,	name = _('Left spotlight switch - FRONT')..' '..rearCptSuffix,	category = {_('Main instrument panel'), _('Illumination'), _('Rear Cockpit')}},
{down = device_commands.Button_421,cockpit_device_id = devices.LIGHTS,	value_down = 1.0,	name = _('Right spotlight switch - LAND')..' '..rearCptSuffix,		category = {_('Main instrument panel'), _('Illumination'), _('Rear Cockpit')}},
{down = device_commands.Button_421,cockpit_device_id = devices.LIGHTS,	value_down = 0.0,	name = _('Right spotlight switch - FRONT')..' '..rearCptSuffix,	category = {_('Main instrument panel'), _('Illumination'), _('Rear Cockpit')}},

--Pitot heat
{down = device_commands.Button_488, up = device_commands.Button_488, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Pitot heat')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

--landing gear override
{down = device_commands.Button_490, up = device_commands.Button_490, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Landing gear override')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

-------------------------------------------------------------Main Right panel-----------------------------------------------------
----------------------------------------------------------------------------------------------------------------------------------
--Batteries
{down = device_commands.Button_401, up = device_commands.Button_401, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Left Battery Isolation switch')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Electrical system panel'), _('Rear Cockpit')}},

{down = device_commands.Button_403, up = device_commands.Button_403, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Right Battery Isolation switch')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Electrical system panel'), _('Rear Cockpit')}},

--ESS BUS Transfer
{down = device_commands.Button_405, up = device_commands.Button_405, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('ESS BUS Transfer')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Electrical system panel'), _('Rear Cockpit')}},

--Warning/Caution
{down = device_commands.Button_406,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CAWS Panel Bright')..' '..rearCptSuffix,		category = {_('Main instrument panel'), _('Rear Cockpit')}},
{down = device_commands.Button_406,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CAWS Panel Dim')..' '..rearCptSuffix,	category = {_('Main instrument panel'), _('Rear Cockpit')}},
{down = device_commands.Button_407, up= device_commands.Button_407, cockpit_device_id = devices.SYSTEMS,	value_down = 1.0, value_up= 0.0 ,name = _('Lamp test')..' '..rearCptSuffix,category = {_('Main instrument panel'), _('Rear Cockpit')}},

-------------------------------------------------------------Left Console----------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------
--Fuel panel
{down = device_commands.Button_476, up = device_commands.Button_476, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Fuselage tank Pump')..' '..rearCptSuffix, category = {_('Left Console'), _('Fuel panel'), _('Rear Cockpit')}},

{down = device_commands.Button_477, up = device_commands.Button_477, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Engine Fuel Valve')..' '..rearCptSuffix, category = {_('Left Console'), _('Fuel panel'), _('Rear Cockpit')}},

{down = device_commands.Button_48, up = device_commands.Button_478, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Center wing tank Qty')..' '..rearCptSuffix, category = {_('Left Console'), _('Fuel panel'), _('Rear Cockpit')}},


{down = device_commands.Button_480,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Fuel Transfer Left ANT')..' '..rearCptSuffix,	category = {_('Left Console'), _('Fuel panel'), _('Rear Cockpit')}},
{down = device_commands.Button_480,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Fuel Transfer Left MAN')..' '..rearCptSuffix,	category = {_('Left Console'), _('Fuel panel'), _('Rear Cockpit')}},

{down = device_commands.Button_481,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Fuel Transfer Center 1 ANT')..' '..rearCptSuffix,	category = {_('Left Console'), _('Fuel panel'), _('Rear Cockpit')}},
{down = device_commands.Button_481,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Fuel Transfer Center 1 MAN')..' '..rearCptSuffix,	category = {_('Left Console'), _('Fuel panel'), _('Rear Cockpit')}},

{down = device_commands.Button_482,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Fuel Transfer Center 2 ANT')..' '..rearCptSuffix,	category = {_('Left Console'), _('Fuel panel'), _('Rear Cockpit')}},
{down = device_commands.Button_482,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Fuel Transfer Center 2 MAN')..' '..rearCptSuffix,	category = {_('Left Console'), _('Fuel panel'), _('Rear Cockpit')}},

{down = device_commands.Button_483,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Fuel Transfer Right ANT')..' '..rearCptSuffix,	category = {_('Left Console'), _('Fuel panel'), _('Rear Cockpit')}},
{down = device_commands.Button_483,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Fuel Transfer Right MAN')..' '..rearCptSuffix,	category = {_('Left Console'), _('Fuel panel'), _('Rear Cockpit')}},

--Engine panel
--{combos = {{key = 'P', reformers = {'LShift'}}}, down = 8002, cockpit_device_id = devices.SYSTEMS, name = _("GPU Connection"), category =_('External GPU')},
{down = device_commands.Button_422, up = device_commands.Button_422, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('GPU on/off')..' '..rearCptSuffix, category = {_('Left Console'), _('Engine control panel'), _('External GPU'), _('Rear Cockpit')}},

{down = device_commands.Button_424, up = device_commands.Button_424, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Anti-Ice')..' '..rearCptSuffix, category = {_('Left Console'), _('Engine control panel'), _('Rear Cockpit')}},

{down = device_commands.Button_423, up = device_commands.Button_423, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Computer')..' '..rearCptSuffix, category = {_('Left Console'), _('Engine control panel'), _('Rear Cockpit')}},

{down = device_commands.Button_427, up = device_commands.Button_427, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, value_up = 0.0, name = _("Ignition Mode Selector - START")..' '..rearCptSuffix, category = {_('Left Console'), _('Engine control panel'), _('Rear Cockpit')}},
{down = device_commands.Button_427, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, name = _("Ignition Mode Selector - OFF")..' '..rearCptSuffix, category = {_('Left Console'), _('Engine control panel'), _('Rear Cockpit')}},
{down = device_commands.Button_427, cockpit_device_id = devices.SYSTEMS, value_down = -1.0, name = _("Ignition Mode Selector - CONTINUOUS")..' '..rearCptSuffix, category = {_('Left Console'), _('Engine control panel'), _('Rear Cockpit')}},

{down = device_commands.Button_426, up = device_commands.Button_426, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Abort')..' '..rearCptSuffix, category = {_('Left Console'), _('Engine control panel'), _('Rear Cockpit')}},

{down = device_commands.Button_428, up = device_commands.Button_428, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Ignition light test')..' '..rearCptSuffix, category = {_('Left Console'), _('Engine control panel'), _('Rear Cockpit')}},

{pressed = device_commands.Button_915, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('Ignition Dimmer Increase')..' '..rearCptSuffix, category = {_('Left Console'), _('Engine control panel'), _('Rear Cockpit')}},
{pressed = device_commands.Button_915, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('Ignition Dimmer Decrease')..' '..rearCptSuffix, category = {_('Left Console'), _('Engine control panel'), _('Rear Cockpit')}},

{down = device_commands.Button_425, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, name = _("Starter Mode Selector Crank")..' '..rearCptSuffix, category = {_('Left Console'), _('Engine control panel'), _('Rear Cockpit')}},
{down = device_commands.Button_425, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, name = _("Starter Mode Selector Normal")..' '..rearCptSuffix, category = {_('Left Console'), _('Engine control panel'), _('Rear Cockpit')}},

--Throttle panel
{down = device_commands.Button_489, up= device_commands.Button_489, cockpit_device_id = devices.SYSTEMS,	value_down = 1.0, value_up= 0.0 ,name = _('Landing gear warning mute')..' '..rearCptSuffix,category = {_('Left Console'), _('Engine control panel'), _('Rear Cockpit')}},

{down = device_commands.Button_904, up = device_commands.Button_904, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = ('Fuel Enrichment')..' '..rearCptSuffix, category = {_('Left Console'), _('Throttle lever'), _('Flight Control'), _('Rear Cockpit')}},

--Emergency panel
{down = device_commands.Button_470,up = device_commands.Button_470, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, value_up=0.0,	name = _('Emergency Pitch Trim Lamp Test')..' '..rearCptSuffix,category = {_('Left Console'), _('Emergency panel'), _('Rear Cockpit')}},

{pressed = device_commands.Button_921, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('Emergency Pitch Trim Dimmer Increase')..' '..rearCptSuffix, category = {_('Left Console'), _('Emergency panel'), _('Rear Cockpit')}},
{pressed = device_commands.Button_921, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('Emergency Pitch Trim Dimmer Decrease')..' '..rearCptSuffix, category = {_('Left Console'), _('Emergency panel'), _('Rear Cockpit')}},

{down = device_commands.Button_436,up = device_commands.Button_436, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, value_up=0.0,	name = _('Emergency air brake retract')..' '..rearCptSuffix,category = {_('Left Console'), _('Emergency panel'), _('Rear Cockpit')}},

{down = device_commands.Button_467,up = device_commands.Button_467, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, value_up=0.0,	name = _('Aileron HYD override')..' '..rearCptSuffix,category = {_('Left Console'), _('Emergency panel'), _('Rear Cockpit')}},

{down = device_commands.Button_437,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Emergency landing gear extension - Extend')..' '..rearCptSuffix,	category = {_('Left Console'), _('Emergency panel'), _('Rear Cockpit')}},

{down = device_commands.Button_468,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Pitch trim cutout guard OPEN')..' '..rearCptSuffix,	category = {_('Left Console'), _('Emergency panel'), _('Rear Cockpit')}},
{down = device_commands.Button_468,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Pitch trim cutout guard CLOSE')..' '..rearCptSuffix,	category = {_('Left Console'), _('Emergency panel'), _('Rear Cockpit')}},

{down = device_commands.Button_493,up = device_commands.Button_493, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, value_up=0.0,	name = _('Pitch trim cutout DOWN')..' '..rearCptSuffix,category = {_('Left Console'), _('Emergency panel'), _('Rear Cockpit')}},
{down = device_commands.Button_469,up = device_commands.Button_469, cockpit_device_id = devices.SYSTEMS, value_down =-1.0, value_up=0.0,	name = _('Pitch trim cutout UP')..' '..rearCptSuffix,category = {_('Left Console'), _('Emergency panel'), _('Rear Cockpit')}},

--Breakers panel
{down = device_commands.Button_494,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Backup ADI - OUT')..' '..rearCptSuffix,	category = {_('Left Console'), _('Circuit breaker panel'), _('Rear Cockpit')}},
{down = device_commands.Button_494,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Backup ADI - IN')..' '..rearCptSuffix,	category = {_('Left Console'), _('Circuit breaker panel'), _('Rear Cockpit')}},

{down = device_commands.Button_495,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB RPM N1 - OUT')..' '..rearCptSuffix,	category = {_('Left Console'), _('Circuit breaker panel'), _('Rear Cockpit')}},
{down = device_commands.Button_495,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB RPM N1 - IN')..' '..rearCptSuffix,	category = {_('Left Console'), _('Circuit breaker panel'), _('Rear Cockpit')}},

{down = device_commands.Button_496,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB RPM N2 - OUT')..' '..rearCptSuffix,	category = {_('Left Console'), _('Circuit breaker panel'), _('Rear Cockpit')}},
{down = device_commands.Button_496,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB RPM N2 - IN')..' '..rearCptSuffix,	category = {_('Left Console'), _('Circuit breaker panel'), _('Rear Cockpit')}},

{down = device_commands.Button_497,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB ITT - OUT')..' '..rearCptSuffix,	category = {_('Left Console'), _('Circuit breaker panel'), _('Rear Cockpit')}},
{down = device_commands.Button_497,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB ITT - IN')..' '..rearCptSuffix,	category = {_('Left Console'), _('Circuit breaker panel'), _('Rear Cockpit')}},

{down = device_commands.Button_498,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB OXY SYS/HYD SYS PRESS IND - OUT')..' '..rearCptSuffix,	category = {_('Left Console'), _('Circuit breaker panel'), _('Rear Cockpit')}},
{down = device_commands.Button_498,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB OXY SYS/HYD SYS PRESS IND - IN')..' '..rearCptSuffix,	category = {_('Left Console'), _('Circuit breaker panel'), _('Rear Cockpit')}},

{down = device_commands.Button_499,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB VOR DC - OUT')..' '..rearCptSuffix,	category = {_('Left Console'), _('Circuit breaker panel'), _('Rear Cockpit')}},
{down = device_commands.Button_499,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB VOR DC - IN')..' '..rearCptSuffix,	category = {_('Left Console'), _('Circuit breaker panel'), _('Rear Cockpit')}},

{down = device_commands.Button_500,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Oil temp IND - OUT')..' '..rearCptSuffix,	category = {_('Left Console'), _('Circuit breaker panel'), _('Rear Cockpit')}},
{down = device_commands.Button_500,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Oil temp IND - IN')..' '..rearCptSuffix,	category = {_('Left Console'), _('Circuit breaker panel'), _('Rear Cockpit')}},

{down = device_commands.Button_501,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Red cockpit lighting - OUT')..' '..rearCptSuffix,	category = {_('Left Console'), _('Circuit breaker panel'), _('Rear Cockpit')}},
{down = device_commands.Button_501,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Red cockpit lighting - IN')..' '..rearCptSuffix,	category = {_('Left Console'), _('Circuit breaker panel'), _('Rear Cockpit')}},

{down = device_commands.Button_502,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Instruments and storm lights - OUT')..' '..rearCptSuffix,	category = {_('Left Console'), _('Circuit breaker panel'), _('Rear Cockpit')}},
{down = device_commands.Button_502,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Instruments and storm lights - IN')..' '..rearCptSuffix,	category = {_('Left Console'), _('Circuit breaker panel'), _('Rear Cockpit')}},

{down = device_commands.Button_503,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Console lights - OUT')..' '..rearCptSuffix,	category = {_('Left Console'), _('Circuit breaker panel'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_503,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Console lights - IN')..' '..rearCptSuffix,	category = {_('Left Console'), _('Circuit breaker panel'), _('Rear Cockpit')}},

{down = device_commands.Button_504,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Engine starter - OUT')..' '..rearCptSuffix,	category = {_('Left Console'), _('Circuit breaker panel'), _('Rear Cockpit')}},
{down = device_commands.Button_504,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Engine starter - IN')..' '..rearCptSuffix,	category = {_('Left Console'), _('Circuit breaker panel'), _('Rear Cockpit')}},

{down = device_commands.Button_505,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB interphone - OUT')..' '..rearCptSuffix,	category = {_('Left Console'), _('Circuit breaker panel'), _('Rear Cockpit')}},
{down = device_commands.Button_505,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB interphone - IN')..' '..rearCptSuffix,	category = {_('Left Console'), _('Circuit breaker panel'), _('Rear Cockpit')}},

{down = device_commands.Button_506,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Seat adjustment - OUT')..' '..rearCptSuffix,	category = {_('Left Console'), _('Circuit breaker panel'), _('Rear Cockpit')}},
{down = device_commands.Button_506,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Seat adjustment - IN')..' '..rearCptSuffix,	category = {_('Left Console'), _('Circuit breaker panel'), _('Rear Cockpit')}},

-------------------------------------------------------------Right Console-------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------------

--Illumination panel
{pressed = device_commands.Button_130, cockpit_device_id = devices.LIGHTS, value_pressed = -1, name = _('Instrument lighting Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('Illumination'), _('Rear Cockpit')}},
{pressed = device_commands.Button_130, cockpit_device_id = devices.LIGHTS, value_pressed = 1, name = _('Instrument lighting Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('Illumination'), _('Rear Cockpit')}},

{pressed = device_commands.Button_128, cockpit_device_id = devices.LIGHTS, value_pressed = -1, name = _('Console integral lighting Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('Illumination'), _('Rear Cockpit')}},
{pressed = device_commands.Button_128, cockpit_device_id = devices.LIGHTS, value_pressed = 1, name = _('Console integral lighting Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('Illumination'), _('Rear Cockpit')}},

{down = device_commands.Button_417,cockpit_device_id = devices.LIGHTS,	value_down = 1.0,	name = _('Storm lights - ON')..' '..rearCptSuffix,	category = {_('Right Console'), _('Illumination'), _('Rear Cockpit')}},
{down = device_commands.Button_417,cockpit_device_id = devices.LIGHTS,	value_down = 0.0,	name = _('Storm lights - OFF')..' '..rearCptSuffix,	category = {_('Right Console'), _('Illumination'), _('Rear Cockpit')}},

{down = device_commands.Button_416,cockpit_device_id = devices.LIGHTS,	value_down = 1.0,	name = _('Red flood lighting - BRIGHT')..' '..rearCptSuffix,	category = {_('Right Console'), _('Illumination'), _('Rear Cockpit')}},
{down = device_commands.Button_416,cockpit_device_id = devices.LIGHTS,	value_down = 0.5,	name = _('Red flood lighting - OFF')..' '..rearCptSuffix,	category = {_('Right Console'), _('Illumination'), _('Rear Cockpit')}},
{down = device_commands.Button_416,cockpit_device_id = devices.LIGHTS,	value_down = 0.0,	name = _('Red flood lighting - TENUE')..' '..rearCptSuffix,	category = {_('Right Console'), _('Illumination'), _('Rear Cockpit')}},

--VOR/ILS/MB AN/ARN-127 panel
{down = device_commands.Button_60, up = device_commands.Button_60, cockpit_device_id = devices.ARN127,value_down = 1.0,value_up = 0.0, name = _('VOR-ILS-MB test VOR/MKR')..' '..rearCptSuffix, category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel'), _('Rear Cockpit')}},

{down = device_commands.Button_61, up = device_commands.Button_61, cockpit_device_id = devices.ARN127,value_down = 1.0,value_up = 0.0, name = _('VOR-ILS-MB test VHF NAV DIGITS')..' '..rearCptSuffix, category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel'), _('Rear Cockpit')}},

{pressed = device_commands.Button_62, cockpit_device_id  = devices.ARN127, value_pressed = -1.0, name = _('VOR/ILS Dimmer Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel'), _('Rear Cockpit')}},
{pressed = device_commands.Button_62, cockpit_device_id  = devices.ARN127, value_pressed = 1.0, name = _('VOR/ILS Dimmer Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel'), _('Rear Cockpit')}},

{down = device_commands.Button_63, cockpit_device_id  = devices.ARN127, value_down = 0.0, name = _('VOR-ILS-MB (108-117) Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel'), _('Rear Cockpit')}},
{down = device_commands.Button_63, cockpit_device_id  = devices.ARN127, value_down = 1.0, name = _('VOR-ILS-MB (108-117) Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel'), _('Rear Cockpit')}},

{down = device_commands.Button_64, cockpit_device_id  = devices.ARN127, value_down = 0.0, name = _('VOR-ILS-MB Frequency selector (0-9) Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel'), _('Rear Cockpit')}},
{down = device_commands.Button_64, cockpit_device_id  = devices.ARN127, value_down = 1.0, name = _('VOR-ILS-MB Frequency selector (0-9) Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel'), _('Rear Cockpit')}},

{down = device_commands.Button_65, cockpit_device_id  = devices.ARN127, value_down = 0.0, name = _('VOR-ILS-MB Frequency selector (00/50) Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel'), _('Rear Cockpit')}},
{down = device_commands.Button_65, cockpit_device_id  = devices.ARN127, value_down = 1.0, name = _('VOR-ILS-MB Frequency selector (00/50) Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel'), _('Rear Cockpit')}},

{pressed = device_commands.Button_66, cockpit_device_id  = devices.ARN127, value_pressed = 0.0, name = _('NAV VOL Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel'), _('Rear Cockpit')}},
{pressed = device_commands.Button_66, cockpit_device_id  = devices.ARN127, value_pressed = 1.0, name = _('NAV VOL Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel'), _('Rear Cockpit')}},

--Intercom
{down = device_commands.Button_74, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('INTERCOM Volume PUSH')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},
{down = device_commands.Button_74, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('INTERCOM Volume PULL')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},

{pressed = device_commands.Button_75, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('INTERCOM Volume Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},
{pressed = device_commands.Button_75, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('INTERCOM Volume Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},

{down = device_commands.Button_76, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('VHF Volume PUSH')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},
{down = device_commands.Button_76, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('VHF Volume PULL')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},

{pressed = device_commands.Button_77, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('VHF Volume Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},
{pressed = device_commands.Button_77, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('VHF Volume Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},

{down = device_commands.Button_78, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('HOT MIC RX Volume PUSH')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},
{down = device_commands.Button_78, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('HOT MIC RX Volume PULL')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},

{pressed = device_commands.Button_79, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('HOT MIC RX Volume Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},
{pressed = device_commands.Button_79, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('HOT MIC RX Volume Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},

{down = device_commands.Button_80, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('VOR Volume PUSH')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},
{down = device_commands.Button_80, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('VOR Volume PULL')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},

{pressed = device_commands.Button_81, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('VOR Volume Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},
{pressed = device_commands.Button_81, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('VOR Volume Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},

{down = device_commands.Button_82, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('Marker Beacon Volume PUSH')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},
{down = device_commands.Button_82, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('Marker Beacon Volume PULL')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},

{pressed = device_commands.Button_83, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('Marker Beacon Volume Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},
{pressed = device_commands.Button_83, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('Marker Beacon Volume Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},

{down = device_commands.Button_84, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('HOT MIC TX Volume PUSH')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},
{down = device_commands.Button_84, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('HOT MIC TX Volume PULL')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},

{down = device_commands.Button_85, up = device_commands.Button_85, cockpit_device_id = devices.INTERCOM,value_down = 1.0,value_up = 0.0, name = _('INTERCOM call button')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},

{pressed = device_commands.Button_86, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('INTERCOM master volume knob Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},
{pressed = device_commands.Button_86, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('INTERCOM master volume knob Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},

{down = device_commands.Button_87, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('UHF Volume PUSH')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},
{down = device_commands.Button_87, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('UHF Volume PULL')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},

{pressed = device_commands.Button_88, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('UHF Volume Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},
{pressed = device_commands.Button_88, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('UHF Volume Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},

{down = device_commands.Button_89, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('TACAN Volume PUSH')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},
{down = device_commands.Button_89, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('TACAN Volume PULL')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},

{pressed = device_commands.Button_90, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('TACAN Volume in Intercom Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},
{pressed = device_commands.Button_90, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('TACAN Volume in Intercom Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},

{down = device_commands.Button_91, cockpit_device_id  = devices.INTERCOM, value_down = -1, name = _('INTERCOM Main mode selector Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},
{down = device_commands.Button_91, cockpit_device_id  = devices.INTERCOM, value_down = 1, name = _('INTERCOM Main mode selector Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('Rear Cockpit')}},

--VHF Radio AN/ARC-134 panel
{down = device_commands.Button_60, cockpit_device_id  = devices.ARC134, value_down = 0.0, name = _('VHF power switch ON')..' '..rearCptSuffix, category = {_('Right Console'), _('VHF radio AN/ARC-134 panel'), _('Rear Cockpit')}},
{down = device_commands.Button_60, cockpit_device_id  = devices.ARC134, value_down = 1.0, name = _('VHF power switch OFF')..' '..rearCptSuffix, category = {_('Right Console'), _('VHF radio AN/ARC-134 panel'), _('Rear Cockpit')}},

{down = device_commands.Button_61, cockpit_device_id  = devices.ARC134, value_down = -1, name = _('VHF Frequency selector (X0X.XXX) Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('VHF radio AN/ARC-134 panel'), _('Rear Cockpit')}},
{down = device_commands.Button_61, cockpit_device_id  = devices.ARC134, value_down = 1, name = _('VHF Frequency selector (X0X.XXX) Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('VHF radio AN/ARC-134 panel'), _('Rear Cockpit')}},

{down = device_commands.Button_62, cockpit_device_id  = devices.ARC134, value_down = -1, name = _('VHF Frequency selector (XX0.XXX) Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('VHF radio AN/ARC-134 panel'), _('Rear Cockpit')}},
{down = device_commands.Button_62, cockpit_device_id  = devices.ARC134, value_down = 1, name = _('VHF Frequency selector (XX0.XXX) Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('VHF radio AN/ARC-134 panel'), _('Rear Cockpit')}},

{down = device_commands.Button_63, cockpit_device_id  = devices.ARC134, value_down = -1, name = _('VHF Frequency selector (XXX.0XX) Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('VHF radio AN/ARC-134 panel'), _('Rear Cockpit')}},
{down = device_commands.Button_63, cockpit_device_id  = devices.ARC134, value_down = 1, name = _('VHF Frequency selector (XXX.0XX) Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('VHF radio AN/ARC-134 panel'), _('Rear Cockpit')}},

{down = device_commands.Button_64, cockpit_device_id  = devices.ARC134, value_down = -1, name = _('VHF Frequency selector (XXX.X00) Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('VHF radio AN/ARC-134 panel'), _('Rear Cockpit')}},
{down = device_commands.Button_64, cockpit_device_id  = devices.ARC134, value_down = 1, name = _('VHF Frequency selector (XXX.X00) Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('VHF radio AN/ARC-134 panel'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_65, up = device_commands.Button_65, cockpit_device_id = devices.ARC134,value_down = 1.0,value_up = 0.0, name = _('Display test')..' '..rearCptSuffix, category = {_('Right Console'), _('VHF radio AN/ARC-134 panel'), _('Rear Cockpit')}},

{pressed = device_commands.Button_66, cockpit_device_id  = devices.ARC134, value_pressed = -1, name = _('VHF dimmer Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('VHF radio AN/ARC-134 panel'), _('Rear Cockpit')}},
{pressed = device_commands.Button_66, cockpit_device_id  = devices.ARC134, value_pressed = 1, name = _('VHF dimmer Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('VHF radio AN/ARC-134 panel'), _('Rear Cockpit')}},

{pressed = device_commands.Button_67, cockpit_device_id  = devices.ARC134, value_pressed = -1, name = _('VHF COMM Volume Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('VHF radio AN/ARC-134 panel'), _('Rear Cockpit')}},
{pressed = device_commands.Button_67, cockpit_device_id  = devices.ARC134, value_pressed = 1, name = _('VHF COMM Volume Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('VHF radio AN/ARC-134 panel'), _('Rear Cockpit')}},

--Oxygen
{down = device_commands.Button_429,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Oxygen supply - ON')..' '..rearCptSuffix,	category = {_('Right Console'), _('Oxygen system'), _('Rear Cockpit')}},
{down = device_commands.Button_429,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Oxygen supply - OFF')..' '..rearCptSuffix,	category = {_('Right Console'), _('Oxygen system'), _('Rear Cockpit')}},

{down = device_commands.Button_527,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Oxygen pressure warning switch - BOTH')..' '..rearCptSuffix,	category = {_('Right Console'), _('Oxygen system'), _('Rear Cockpit')}},
{down = device_commands.Button_527,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Oxygen pressure warning switch - FRONT')..' '..rearCptSuffix,	category = {_('Right Console'), _('Oxygen system'), _('Rear Cockpit')}},

{down = device_commands.Button_997, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, name = _('Oxygen Regulator Control - 100%')..' '..rearCptSuffix,	category = {_('Ejection seat'), _('Oxygen system'), _('Rear Cockpit')}},
{down = device_commands.Button_997, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, name = _('Oxygen Regulator Control - AIRMIX')..' '..rearCptSuffix,	category = {_('Ejection seat'), _('Oxygen system'), _('Rear Cockpit')}},

----------------------------------------------------------------Canopy emergency jettison----------------------------------------
---------------------------------------------------------------------------------------------------------------------------------
{down = device_commands.Button_515,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,name = _('Canopy emergency jettison OUT')..' '..rearCptSuffix,	category = {_('Systems'), _('Rear Cockpit')}},

--Map Case
{pressed = device_commands.Button_902,cockpit_device_id = devices.SYSTEMS,	value_pressed = 1.0,	name = _('Map Case Cover Open')..' '..rearCptSuffix,	category = {_('Right Console'), _('Rear Cockpit')}},
{pressed = device_commands.Button_902,cockpit_device_id = devices.SYSTEMS,	value_pressed = -1.0,	name = _('Map Case Cover Close')..' '..rearCptSuffix,	category = {_('Right Console'), _('Rear Cockpit')}},

-- Control Stick (miscellaneous buttons)
{down = device_commands.Button_906, up = device_commands.Button_906, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Rain Repelent')..' '..rearCptSuffix, category = {_('Control stick'), _('Systems'), _('Rear Cockpit')}},

{down = device_commands.Button_925, up = device_commands.Button_925, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Camera Button')..' '..rearCptSuffix, category = {_('Control stick'), _('Systems'), _('Rear Cockpit')}},

{down = device_commands.Button_927, up = device_commands.Button_927, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Stores Release Button')..' '..rearCptSuffix, category = {_('Control stick'), _('Smoke System'), _('Rear Cockpit')}},

{down = device_commands.Button_929, cockpit_device_id = devices.SYSTEMS,value_down = 1.0, name = _('Stores Release Guard OPEN')..' '..rearCptSuffix, category = {_('Control stick'), _('Smoke System'), _('Rear Cockpit')}},
{down = device_commands.Button_929, cockpit_device_id = devices.SYSTEMS,value_down = 0.0, name = _('Stores Release Guard CLOSE')..' '..rearCptSuffix, category = {_('Control stick'), _('Smoke System'), _('Rear Cockpit')}},

{down = device_commands.Button_931, up = device_commands.Button_931, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Fixed Weapons Trigger')..' '..rearCptSuffix, category = {_('Control stick'), _('Smoke System'), _('Rear Cockpit')}},

{down = device_commands.Button_933, cockpit_device_id = devices.SYSTEMS,value_down = 1.0, name = _('Trigger Safety Catch UNLOCK')..' '..rearCptSuffix, category = {_('Control stick'), _('Smoke System'), _('Rear Cockpit')}},
{down = device_commands.Button_933, cockpit_device_id = devices.SYSTEMS,value_down = 0.0, name = _('Trigger Safety Catch LOCK')..' '..rearCptSuffix, category = {_('Control stick'), _('Smoke System'), _('Rear Cockpit')}},

-- Ejection handle
{down = device_commands.Button_519,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0, name = _('Ejection Seat Handle PULL')..' '..rearCptSuffix,	category = {_('Ejection seat'), _('Ejection system'), _('Rear Cockpit')}},
{down = device_commands.Button_519,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0, name = _('Ejection Seat Handle PUSH')..' '..rearCptSuffix,	category = {_('Ejection seat'), _('Ejection system'), _('Rear Cockpit')}},
{pressed = device_commands.Button_935,cockpit_device_id = devices.SYSTEMS, value_pressed = -1.0, name = _('Ejection Seat Handle Safety Pin INSTALL')..' '..rearCptSuffix, category = {_('Ejection seat'), _('Ejection system'), _('Rear Cockpit')}},
{pressed = device_commands.Button_935,cockpit_device_id = devices.SYSTEMS, value_pressed = 1.0, name = _('Ejection Seat Handle Safety Pin REMOVE')..' '..rearCptSuffix, category = {_('Ejection seat'), _('Ejection system'), _('Rear Cockpit')}},
{down = device_commands.Button_691,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0, name = _('Ejection Seat Priority Lever ON')..' '..rearCptSuffix,	category = {_('Ejection seat'), _('Ejection system'), _('Rear Cockpit')}},
{down = device_commands.Button_691,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0, name = _('Ejection Seat Priority Lever OFF')..' '..rearCptSuffix,	category = {_('Ejection seat'), _('Ejection system'), _('Rear Cockpit')}},

----------------------------------------------------------------Blackout curtain-------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------
--{down = device_commands.Button_557, cockpit_device_id = devices.SYSTEMS, name = _('Blackout curtain'), category = _('Systems')},

----------------------------------------------------------------Canopy emergency jettison----------------------------------------
---------------------------------------------------------------------------------------------------------------------------------
{down = device_commands.Button_226,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,name = _('Canopy emergency jettison OUT'),	category = {_('Systems')}},

-------------------------------------------------------------Smoke system-------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------------------------
--{down = 8513, cockpit_device_id = devices.SYSTEMS, name = _("Toggle Smoke On/Off"), category =_('Smoke System')},
--{down = 8511, cockpit_device_id = devices.SYSTEMS, name = _('Toggle Smoke Color'), category =_('Smoke System')},

-------------------------------------------------------------Helmet glass-------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------------------------
{down = 8028, cockpit_device_id = devices.HELMET, name = _('Helmet glass'), category =_('General')},

{pressed = iCommandPlaneTrimUp, up = iCommandPlaneTrimStop, name = _('Trim: Nose Up'), category = {_('Control stick'), _('Flight Control')}},
{pressed = iCommandPlaneTrimDown, up = iCommandPlaneTrimStop, name = _('Trim: Nose Down'), category = {_('Control stick'), _('Flight Control')}},
{pressed = iCommandPlaneTrimLeft, up = iCommandPlaneTrimStop, name = _('Trim: Left Wing Down'), category = {_('Control stick'), _('Flight Control')}},
{pressed = iCommandPlaneTrimRight, up = iCommandPlaneTrimStop, name = _('Trim: Right Wing Down'), category = {_('Control stick'), _('Flight Control')}},
--{pressed = iCommandPlaneTrimLeftRudder, up = iCommandPlaneTrimStop, name = _('Trim: Rudder Left'), category = _('Flight Control')},
--{pressed = iCommandPlaneTrimRightRudder, up = iCommandPlaneTrimStop, name = _('Trim: Rudder Right'), category = _('Flight Control')},

-------------------------------------------------------------Net-Specific Controls------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------------------------
{down = iCommandNetCrewRequestControl, name = _('Request Aircraft Control'), category = _('Flight Control')},

-- General
{down = iCommandScreenShot, name = _('Screenshot'), category = _('General')},
{combos = {{key = 'P',reformers = {'RShift'}}}, down = iCommandCockpitShowPilotOnOff, name = _('Show Pilot Body'), category = _('General')},
{down = iCommandEnginesStart, name = _('Auto Start'), category = _('Cheat')},
{down = iCommandEnginesStop, name = _('Auto Stop'), category = _('Cheat')},

-- Flight Control
{down = iCommandPlaneUpStart, up = iCommandPlaneUpStop, name = _('Aircraft Pitch Down'), category = _('Flight Control')},
{down = iCommandPlaneDownStart, up = iCommandPlaneDownStop, name = _('Aircraft Pitch Up'), category = _('Flight Control')},
{down = iCommandPlaneLeftStart, up = iCommandPlaneLeftStop, name = _('Aircraft Bank Left'), category = _('Flight Control')},
{down = iCommandPlaneRightStart, up = iCommandPlaneRightStop, name = _('Aircraft Bank Right'), category = _('Flight Control')},
{down = iCommandPlaneLeftRudderStart, up = iCommandPlaneLeftRudderStop, name = _('Aircraft Rudder Left'), category = _('Flight Control')},
{down = iCommandPlaneRightRudderStart, up = iCommandPlaneRightRudderStop, name = _('Aircraft Rudder Right'), category = _('Flight Control')},
--{down = iCommandPlaneTrimCancel, name = _('Trim: Reset'), category = _('Flight Control')},
{pressed = iCommandThrottleIncrease, up = iCommandThrottleStop,  name = _('Throttle Up'), category = _('Flight Control')},
{pressed = iCommandThrottleDecrease, up = iCommandThrottleStop,  name = _('Throttle Down'), category = _('Flight Control')},

{down = 8033, name = _('Toggle Combined Flight Controls Mode (On/Off)'), category = _('Flight Control')},

-- Illumination
--{down= 3256, cockpit_device_id = devices.LIGHTS, value_down = 0, name = 'Pilot pocket light torch on-off', category ={_('Illumination')}},

-- Systems
{down = iCommandPlaneEject, name = _('Eject (3 times)'), category = _('Ejection system')},
{down = iCommandPlaneWheelBrakeOn, up = iCommandPlaneWheelBrakeOff, name = _('Wheel Brake On'), category = _('Systems')},
--{down = iCommandEnginesStart, name = _('Engines Start'), category = _('Systems')},
--{down = iCommandEnginesStop, name = _('Engines Stop'), category = _('Systems')},

{down = iCommandPlaneFonar, name = _('Canopy Open/Close'), category = _('Systems')},

-- Cockpit view
{down = iCommandViewCockpitChangeSeat, value_down = 1, name = _('Occupy Seat 1'),	category = _('View Cockpit')},
{down = iCommandViewCockpitChangeSeat, value_down = 2, name = _('Occupy Seat 2'),	category = _('View Cockpit')},
{down = iCommandToggleMirrors, name = _('Toggle Mirrors'), category = _('View Cockpit')},

-- Cockpit Camera Motion
{down = iCommandViewTransposeModeOn, up = iCommandViewTransposeModeOff, name = _('Camera transpose mode (press and hold)'), category = _('View Cockpit')},
{down = iCommand_ExplorationStart, name = _('Enable visual recon mode'), category = _('View Cockpit')},

--Wheel brake
{down = iCommandPlaneWheelBrakeLeftOn, up = iCommandPlaneWheelBrakeLeftOff, name = _('Wheel Brake Left On/Off'), category = _('Systems')},
{down = iCommandPlaneWheelBrakeRightOn, up = iCommandPlaneWheelBrakeRightOff, name = _('Wheel Brake Right On/Off'), category = _('Systems')},

-- IFR Hood
{down = 8027, cockpit_device_id = devices.SYSTEMS, name = _("IFR Hood"), category =_('Systems')},

{down    = iCommandViewNightVisionGogglesOn   , name = _('Toggle goggles')   , category = _('NVG')},
{pressed = iCommandPlane_Helmet_Brightess_Up  , name = _('Gain goggles up')  , category = _('NVG')},
{pressed = iCommandPlane_Helmet_Brightess_Down, name = _('Gain goggles down'), category = _('NVG')},

})

join(base.axisCommands,{

--{combos = defaultDeviceAssignmentFor("roll"), 		action = iCommandPlaneRoll, 			name = _('Roll')},
{combos = defaultDeviceAssignmentFor("roll"), 		action = 8035, 			name = _('Roll')},
--{combos = defaultDeviceAssignmentFor("pitch"), 		action = iCommandPlanePitch, 			name = _('Pitch')},
{combos = defaultDeviceAssignmentFor("pitch"), 		action = 8034, 			name = _('Pitch')},
--{combos = defaultDeviceAssignmentFor("rudder"), 	action = iCommandPlaneRudder, 			name = _('Rudder')},
{combos = defaultDeviceAssignmentFor("rudder"), 	action = 8036, 			name = _('Rudder')},
{combos = defaultDeviceAssignmentFor("thrust"), 	action = iCommandPlaneThrustCommon, 	name = _('Thrust')},
--{combos = defaultDeviceAssignmentFor("thrust"), 	action = 8037, 	name = _('Thrust')},

{action = iCommandLeftWheelBrake,        name = _('Wheel Brake Left')},
{action = iCommandRightWheelBrake,       name = _('Wheel Brake Right')},
{action = iCommandWheelBrake,       	 name = _('Wheel Brakes')},

-- Forward cockpit
--
--VOR/ILS/MB AN/ARN-127 panel
{action = device_commands.Button_81, cockpit_device_id = devices.ARN127, name = _('VOR/ILS Dimmer'), category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel')}},
{action = device_commands.Button_82, cockpit_device_id = devices.ARN127, name = _('VOR-ILS-MB (108-117)'), category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel')}},
{action = device_commands.Button_83, cockpit_device_id = devices.ARN127, name = _('VOR-ILS-MB Frequency selector (0-9)'), category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel')}},
{action = device_commands.Button_84, cockpit_device_id = devices.ARN127, name = _('VOR-ILS-MB Frequency selector (00/50)'), category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel')}},
{action = device_commands.Button_85, cockpit_device_id = devices.ARN127, name = _('NAV VOL'), category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel')}},

-- Rear cockpit
--
--VOR/ILS/MB AN/ARN-127 panel
{action = device_commands.Button_90, cockpit_device_id = devices.ARN127, name = _('VOR/ILS Dimmer')..' '..rearCptSuffix, category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel'), _('Rear Cockpit')}},
{action = device_commands.Button_91, cockpit_device_id = devices.ARN127, name = _('VOR-ILS-MB (108-117)')..' '..rearCptSuffix, category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel'), _('Rear Cockpit')}},
{action = device_commands.Button_92, cockpit_device_id = devices.ARN127, name = _('VOR-ILS-MB Frequency selector (0-9)')..' '..rearCptSuffix, category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel'), _('Rear Cockpit')}},
{action = device_commands.Button_93, cockpit_device_id = devices.ARN127, name = _('VOR-ILS-MB Frequency selector (00/50)')..' '..rearCptSuffix, category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel'), _('Rear Cockpit')}},
{action = device_commands.Button_94, cockpit_device_id = devices.ARN127, name = _('NAV VOL')..' '..rearCptSuffix, category = {_('Right Console'), _('VOR/ILS/MB AN/ARN-127 panel'), _('Rear Cockpit')}},

})

return base
